/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.Sweeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexConnectionPool
extends AbstractConnectionPool
implements ConnectionPool.Multiplexable,
Sweeper.Sweepable {
    private static final Logger LOG = LoggerFactory.getLogger(MultiplexConnectionPool.class);
    private final HttpDestination destination;
    private final Deque<Holder> idleConnections;
    private final Map<Connection, Holder> activeConnections;
    private int maxMultiplex;

    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, Callback requester, int maxMultiplex) {
        super(destination, maxConnections, requester);
        this.destination = destination;
        this.idleConnections = new ArrayDeque<Holder>(maxConnections);
        this.activeConnections = new LinkedHashMap<Connection, Holder>(maxConnections);
        this.maxMultiplex = maxMultiplex;
    }

    @Override
    public Connection acquire() {
        Connection connection = this.activate();
        if (connection == null) {
            int maxPending = 1 + this.destination.getQueuedRequestCount() / this.getMaxMultiplex();
            this.tryCreate(maxPending);
            connection = this.activate();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxMultiplex() {
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            return this.maxMultiplex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxMultiplex(int maxMultiplex) {
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            this.maxMultiplex = maxMultiplex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(Connection connection) {
        boolean accepted = super.accept(connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accepted {} {}", (Object)accepted, (Object)connection);
        }
        if (accepted) {
            MultiplexConnectionPool multiplexConnectionPool = this;
            synchronized (multiplexConnectionPool) {
                Holder holder = new Holder(connection);
                this.activeConnections.put(connection, holder);
                ++holder.count;
            }
            this.active(connection);
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(Connection connection) {
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            return this.activeConnections.containsKey(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCreated(Connection connection) {
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            this.idleConnections.offer(new Holder(connection));
        }
        this.idle(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection activate() {
        Holder result = null;
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            for (Holder holder : this.activeConnections.values()) {
                if (holder.count >= this.maxMultiplex) continue;
                result = holder;
                break;
            }
            if (result == null) {
                Holder holder = this.idleConnections.poll();
                if (holder == null) {
                    return null;
                }
                this.activeConnections.put(holder.connection, holder);
                result = holder;
            }
            ++result.count;
        }
        return this.active(result.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(Connection connection) {
        Holder holder;
        boolean closed = this.isClosed();
        boolean idle = false;
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            int count;
            holder = this.activeConnections.get(connection);
            if (holder != null && (count = --holder.count) == 0) {
                this.activeConnections.remove(connection);
                if (!closed) {
                    this.idleConnections.offerFirst(holder);
                    idle = true;
                }
            }
        }
        if (holder == null) {
            return false;
        }
        this.released(connection);
        if (idle || closed) {
            return this.idle(connection, closed);
        }
        return true;
    }

    @Override
    public boolean remove(Connection connection) {
        return this.remove(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Connection connection, boolean force) {
        boolean removed;
        boolean activeRemoved = true;
        boolean idleRemoved = false;
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            Holder holder = this.activeConnections.remove(connection);
            if (holder == null) {
                activeRemoved = false;
                Iterator<Holder> iterator = this.idleConnections.iterator();
                while (iterator.hasNext()) {
                    holder = iterator.next();
                    if (holder.connection != connection) continue;
                    idleRemoved = true;
                    iterator.remove();
                    break;
                }
            }
        }
        if (activeRemoved || force) {
            this.released(connection);
        }
        boolean bl = removed = activeRemoved || idleRemoved || force;
        if (removed) {
            this.removed(connection);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<Connection> connections;
        super.close();
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            connections = this.idleConnections.stream().map(holder -> holder.connection).collect(Collectors.toList());
            connections.addAll(this.activeConnections.keySet());
        }
        this.close(connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        DumpableCollection idle;
        DumpableCollection active;
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            active = new DumpableCollection("active", new ArrayList<Holder>(this.activeConnections.values()));
            idle = new DumpableCollection("idle", new ArrayList<Holder>(this.idleConnections));
        }
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{active, idle});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sweep() {
        ArrayList toSweep = new ArrayList();
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            this.activeConnections.values().stream().map(holder -> holder.connection).filter(connection -> connection instanceof Sweeper.Sweepable).collect(Collectors.toCollection(() -> toSweep));
        }
        for (Connection connection2 : toSweep) {
            if (!((Sweeper.Sweepable)connection2).sweep()) continue;
            boolean removed = this.remove(connection2, true);
            LOG.warn("Connection swept: {}{}{} from active connections{}{}", new Object[]{connection2, System.lineSeparator(), removed ? "Removed" : "Not removed", System.lineSeparator(), this.dump()});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int idleSize;
        int activeSize;
        MultiplexConnectionPool multiplexConnectionPool = this;
        synchronized (multiplexConnectionPool) {
            activeSize = this.activeConnections.size();
            idleSize = this.idleConnections.size();
        }
        return String.format("%s@%x[connections=%d/%d/%d,multiplex=%d,active=%d,idle=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getPendingConnectionCount(), this.getConnectionCount(), this.getMaxConnectionCount(), this.getMaxMultiplex(), activeSize, idleSize);
    }

    private static class Holder {
        private final Connection connection;
        private int count;

        private Holder(Connection connection) {
            this.connection = connection;
        }

        public String toString() {
            return String.format("%s[%d]", this.connection, this.count);
        }
    }
}

