/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.io.content.PathContentSource;

public class PathRequestContent
extends PathContentSource
implements Request.Content {
    private final String contentType;

    public PathRequestContent(Path filePath) throws IOException {
        this(filePath, 4096);
    }

    public PathRequestContent(Path filePath, int bufferSize) throws IOException {
        this("application/octet-stream", filePath, bufferSize);
    }

    public PathRequestContent(String contentType, Path filePath) throws IOException {
        this(contentType, filePath, 4096);
    }

    public PathRequestContent(String contentType, Path filePath, int bufferSize) throws IOException {
        this(contentType, filePath, null);
        this.setBufferSize(bufferSize);
    }

    public PathRequestContent(String contentType, Path filePath, RetainableByteBufferPool bufferPool) throws IOException {
        super(filePath, bufferPool);
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

