/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class MultiplexConnectionPool
extends AbstractConnectionPool {
    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, Callback requester, int initialMaxMultiplex) {
        this(destination, Pool.StrategyType.FIRST, maxConnections, false, requester, initialMaxMultiplex);
    }

    protected MultiplexConnectionPool(HttpDestination destination, Pool.StrategyType strategy, int maxConnections, boolean cache, Callback requester, int initialMaxMultiplex) {
        super(destination, (Pool<Connection>)new Pool(strategy, maxConnections, cache, connection -> {
            int maxMultiplex = initialMaxMultiplex;
            if (connection instanceof ConnectionPool.MaxMultiplexable) {
                ConnectionPool.MaxMultiplexable maxMultiplexable = (ConnectionPool.MaxMultiplexable)((Object)connection);
                maxMultiplex = maxMultiplexable.getMaxMultiplex();
            }
            return maxMultiplex;
        }), requester, initialMaxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The initial multiplexing factor of connections")
    public int getInitialMaxMultiplex() {
        return super.getInitialMaxMultiplex();
    }

    @Override
    public void setInitialMaxMultiplex(int initialMaxMultiplex) {
        super.setInitialMaxMultiplex(initialMaxMultiplex);
    }
}

