/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestListeners
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(RequestListeners.class);
    private Request.QueuedListener queuedListener;
    private Request.BeginListener beginListener;
    private Request.HeadersListener headersListener;
    private Request.CommitListener commitListener;
    private Request.ContentListener contentListener;
    private Request.SuccessListener successListener;
    private Request.FailureListener failureListener;

    public void addListener(Request.Listener listener) {
        this.addQueuedListener(listener);
        this.addBeginListener(listener);
        this.addHeadersListener(listener);
        this.addCommitListener(listener);
        this.addContentListener(listener);
        this.addSuccessListener(listener);
        this.addFailureListener(listener);
    }

    public void addQueuedListener(Request.QueuedListener listener) {
        Request.QueuedListener existing = this.queuedListener;
        this.queuedListener = existing == null ? listener : request -> {
            RequestListeners.notifyQueued(existing, request);
            RequestListeners.notifyQueued(listener, request);
        };
    }

    protected static void notifyQueued(Request.QueuedListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onQueued(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addBeginListener(Request.BeginListener listener) {
        Request.BeginListener existing = this.beginListener;
        this.beginListener = existing == null ? listener : request -> {
            RequestListeners.notifyBegin(existing, request);
            RequestListeners.notifyBegin(listener, request);
        };
    }

    protected static void notifyBegin(Request.BeginListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onBegin(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addHeadersListener(Request.HeadersListener listener) {
        Request.HeadersListener existing = this.headersListener;
        this.headersListener = existing == null ? listener : request -> {
            RequestListeners.notifyHeaders(existing, request);
            RequestListeners.notifyHeaders(listener, request);
        };
    }

    protected static void notifyHeaders(Request.HeadersListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onHeaders(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addCommitListener(Request.CommitListener listener) {
        Request.CommitListener existing = this.commitListener;
        this.commitListener = existing == null ? listener : request -> {
            RequestListeners.notifyCommit(existing, request);
            RequestListeners.notifyCommit(listener, request);
        };
    }

    protected static void notifyCommit(Request.CommitListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onCommit(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addContentListener(Request.ContentListener listener) {
        Request.ContentListener existing = this.contentListener;
        this.contentListener = existing == null ? listener : (request, byteBuffer) -> {
            RequestListeners.notifyContent(existing, request, byteBuffer);
            RequestListeners.notifyContent(listener, request, byteBuffer);
        };
    }

    protected static void notifyContent(Request.ContentListener listener, Request request, ByteBuffer byteBuffer) {
        try {
            if (listener != null) {
                byteBuffer.clear();
                listener.onContent(request, byteBuffer);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addSuccessListener(Request.SuccessListener listener) {
        Request.SuccessListener existing = this.successListener;
        this.successListener = existing == null ? listener : request -> {
            RequestListeners.notifySuccess(existing, request);
            RequestListeners.notifySuccess(listener, request);
        };
    }

    protected static void notifySuccess(Request.SuccessListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onSuccess(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addFailureListener(Request.FailureListener listener) {
        Request.FailureListener existing = this.failureListener;
        this.failureListener = existing == null ? listener : (request, failure) -> {
            RequestListeners.notifyFailure(existing, request, failure);
            RequestListeners.notifyFailure(listener, request, failure);
        };
    }

    protected static void notifyFailure(Request.FailureListener listener, Request request, Throwable failure) {
        try {
            if (listener != null) {
                listener.onFailure(request, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void clear() {
        this.queuedListener = null;
        this.beginListener = null;
        this.headersListener = null;
        this.commitListener = null;
        this.contentListener = null;
        this.successListener = null;
        this.failureListener = null;
    }

    protected Request.QueuedListener getQueuedListener() {
        return this.queuedListener;
    }

    protected Request.BeginListener getBeginListener() {
        return this.beginListener;
    }

    protected Request.HeadersListener getHeadersListener() {
        return this.headersListener;
    }

    protected Request.CommitListener getCommitListener() {
        return this.commitListener;
    }

    protected Request.ContentListener getContentListener() {
        return this.contentListener;
    }

    protected Request.SuccessListener getSuccessListener() {
        return this.successListener;
    }

    protected Request.FailureListener getFailureListener() {
        return this.failureListener;
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{new ListenerDump("queued", this.getQueuedListener()), new ListenerDump("begin", this.getBeginListener()), new ListenerDump("headers", this.getHeadersListener()), new ListenerDump("commit", this.getCommitListener()), new ListenerDump("content", this.getContentListener()), new ListenerDump("success", this.getSuccessListener()), new ListenerDump("failure", this.getFailureListener())});
    }

    private record ListenerDump(String name, Object listener) {
        @Override
        public String toString() {
            return this.name + " = " + String.valueOf(this.listener);
        }
    }
}

