/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseListeners {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseListeners.class);
    private Response.BeginListener beginListener;
    private Response.HeaderListener headerListener;
    private Response.HeadersListener headersListener;
    private Response.ContentSourceListener contentSourceListener;
    private Response.SuccessListener successListener;
    private Response.FailureListener failureListener;
    private Response.CompleteListener completeListener;

    public ResponseListeners() {
    }

    public ResponseListeners(Response.Listener listener) {
        this.beginListener = listener;
        this.headerListener = listener;
        this.headersListener = listener;
        this.contentSourceListener = listener;
        this.successListener = listener;
        this.failureListener = listener;
        this.completeListener = listener;
    }

    public ResponseListeners(ResponseListeners that) {
        this.beginListener = that.beginListener;
        this.headerListener = that.headerListener;
        this.headersListener = that.headersListener;
        this.contentSourceListener = that.contentSourceListener;
        this.successListener = that.successListener;
        this.failureListener = that.failureListener;
        this.completeListener = that.completeListener;
    }

    public void addBeginListener(Response.BeginListener listener) {
        Response.BeginListener existing = this.beginListener;
        this.beginListener = existing == null ? listener : response -> {
            ResponseListeners.notifyBegin(existing, response);
            ResponseListeners.notifyBegin(listener, response);
        };
    }

    public void notifyBegin(Response response) {
        ResponseListeners.notifyBegin(this.beginListener, response);
    }

    private static void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            if (listener != null) {
                listener.onBegin(response);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addHeaderListener(Response.HeaderListener listener) {
        Response.HeaderListener existing = this.headerListener;
        this.headerListener = existing == null ? listener : (response, field) -> {
            boolean r1 = ResponseListeners.notifyHeader(existing, response, field);
            boolean r2 = ResponseListeners.notifyHeader(listener, response, field);
            return r1 && r2;
        };
    }

    public boolean notifyHeader(Response response, HttpField field) {
        return ResponseListeners.notifyHeader(this.headerListener, response, field);
    }

    private static boolean notifyHeader(Response.HeaderListener listener, Response response, HttpField field) {
        try {
            if (listener != null) {
                return listener.onHeader(response, field);
            }
            return true;
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
            return false;
        }
    }

    public void addHeadersListener(Response.HeadersListener listener) {
        Response.HeadersListener existing = this.headersListener;
        this.headersListener = existing == null ? listener : response -> {
            ResponseListeners.notifyHeaders(existing, response);
            ResponseListeners.notifyHeaders(listener, response);
        };
    }

    public void notifyHeaders(Response response) {
        ResponseListeners.notifyHeaders(this.headersListener, response);
    }

    private static void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            if (listener != null) {
                listener.onHeaders(response);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addContentSourceListener(Response.ContentSourceListener listener) {
        Response.ContentSourceListener existing = this.contentSourceListener;
        if (existing == null) {
            this.contentSourceListener = listener;
        } else if (existing instanceof ContentSourceDemultiplexer) {
            ContentSourceDemultiplexer demultiplexer = (ContentSourceDemultiplexer)existing;
            demultiplexer.addContentSourceListener(listener);
        } else {
            ContentSourceDemultiplexer demultiplexer = new ContentSourceDemultiplexer();
            demultiplexer.addContentSourceListener(existing);
            demultiplexer.addContentSourceListener(listener);
            this.contentSourceListener = demultiplexer;
        }
    }

    public boolean hasContentSourceListeners() {
        return this.contentSourceListener != null;
    }

    public void notifyContentSource(Response response, Content.Source contentSource) {
        if (this.hasContentSourceListeners()) {
            Response.ContentSourceListener contentSourceListener = this.contentSourceListener;
            if (contentSourceListener instanceof ContentSourceDemultiplexer) {
                ContentSourceDemultiplexer demultiplexer = (ContentSourceDemultiplexer)contentSourceListener;
                ResponseListeners.notifyContentSource(demultiplexer, response, contentSource);
            } else {
                ResponseListeners.notifyContentSource(this.contentSourceListener, response, contentSource);
            }
        } else {
            ResponseListeners.notifyContentSource((r, c) -> ResponseListeners.consume(c), response, contentSource);
        }
    }

    private static void consume(Content.Source contentSource) {
        Content.Chunk chunk = contentSource.read();
        if (chunk != null) {
            chunk.release();
        }
        if (chunk == null || !chunk.isLast()) {
            contentSource.demand(() -> ResponseListeners.consume(contentSource));
        }
    }

    private static void notifyContentSource(Response.ContentSourceListener listener, Response response, Content.Source contentSource) {
        try {
            if (listener != null) {
                listener.onContentSource(response, contentSource);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addSuccessListener(Response.SuccessListener listener) {
        Response.SuccessListener existing = this.successListener;
        this.successListener = existing == null ? listener : response -> {
            ResponseListeners.notifySuccess(existing, response);
            ResponseListeners.notifySuccess(listener, response);
        };
    }

    public void notifySuccess(Response response) {
        ResponseListeners.notifySuccess(this.successListener, response);
    }

    private static void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            if (listener != null) {
                listener.onSuccess(response);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addFailureListener(Response.FailureListener listener) {
        Response.FailureListener existing = this.failureListener;
        this.failureListener = existing == null ? listener : (response, failure) -> {
            ResponseListeners.notifyFailure(existing, response, failure);
            ResponseListeners.notifyFailure(listener, response, failure);
        };
    }

    public void notifyFailure(Response response, Throwable failure) {
        ResponseListeners.notifyFailure(this.failureListener, response, failure);
    }

    private static void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            if (listener != null) {
                listener.onFailure(response, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addCompleteListener(Response.CompleteListener listener) {
        this.addCompleteListener(listener, true);
    }

    private void addCompleteListener(Response.CompleteListener listener, boolean includeOtherEvents) {
        Response.CompleteListener existing;
        if (includeOtherEvents) {
            Response.ResponseListener l;
            if (listener instanceof Response.BeginListener) {
                l = (Response.BeginListener)((Object)listener);
                this.addBeginListener((Response.BeginListener)l);
            }
            if (listener instanceof Response.HeaderListener) {
                l = (Response.HeaderListener)((Object)listener);
                this.addHeaderListener((Response.HeaderListener)l);
            }
            if (listener instanceof Response.HeadersListener) {
                l = (Response.HeadersListener)((Object)listener);
                this.addHeadersListener((Response.HeadersListener)l);
            }
            if (listener instanceof Response.ContentSourceListener) {
                l = (Response.ContentSourceListener)((Object)listener);
                this.addContentSourceListener((Response.ContentSourceListener)l);
            }
            if (listener instanceof Response.SuccessListener) {
                l = (Response.SuccessListener)((Object)listener);
                this.addSuccessListener((Response.SuccessListener)l);
            }
            if (listener instanceof Response.FailureListener) {
                l = (Response.FailureListener)((Object)listener);
                this.addFailureListener((Response.FailureListener)l);
            }
        }
        this.completeListener = (existing = this.completeListener) == null ? listener : result -> {
            ResponseListeners.notifyComplete(existing, result);
            ResponseListeners.notifyComplete(listener, result);
        };
    }

    public void notifyComplete(Result result) {
        ResponseListeners.notifyComplete(this.completeListener, result);
    }

    private static void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            if (listener != null) {
                listener.onComplete(result);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void addListener(Response.Listener listener) {
        this.addBeginListener(listener);
        this.addHeaderListener(listener);
        this.addHeadersListener(listener);
        this.addContentSourceListener(listener);
        this.addSuccessListener(listener);
        this.addFailureListener(listener);
        this.addCompleteListener(listener, false);
    }

    public void addResponseListeners(ResponseListeners listeners) {
        this.addBeginListener(listeners.beginListener);
        this.addHeaderListener(listeners.headerListener);
        this.addHeadersListener(listeners.headersListener);
        this.addContentSourceListener(listeners.contentSourceListener);
        this.addSuccessListener(listeners.successListener);
        this.addFailureListener(listeners.failureListener);
        this.addCompleteListener(listeners.completeListener, false);
    }

    private void emitEvents(Response response) {
        ContentResponse contentResponse;
        byte[] content;
        ResponseListeners.notifyBegin(this.beginListener, response);
        Iterator iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = (HttpField)iterator.next();
            if (ResponseListeners.notifyHeader(this.headerListener, response, field)) continue;
            iterator.remove();
        }
        ResponseListeners.notifyHeaders(this.headersListener, response);
        if (response instanceof ContentResponse && (content = (contentResponse = (ContentResponse)response).getContent()) != null && content.length > 0) {
            ByteBufferContentSource byteBufferContentSource = new ByteBufferContentSource(new ByteBuffer[]{ByteBuffer.wrap(content)});
            ResponseListeners.notifyContentSource(this.contentSourceListener, response, (Content.Source)byteBufferContentSource);
        }
    }

    public void emitSuccess(Response response) {
        this.emitEvents(response);
        ResponseListeners.notifySuccess(this.successListener, response);
    }

    public void emitFailure(Response response, Throwable failure) {
        this.emitEvents(response);
        ResponseListeners.notifyFailure(this.failureListener, response, failure);
    }

    public void emitSuccessComplete(Result result) {
        this.emitSuccess(result.getResponse());
        ResponseListeners.notifyComplete(this.completeListener, result);
    }

    public void emitFailureComplete(Result result) {
        this.emitFailure(result.getResponse(), result.getFailure());
        ResponseListeners.notifyComplete(this.completeListener, result);
    }

    private static class ContentSourceDemultiplexer
    implements Response.ContentSourceListener {
        private static final Logger LOG = LoggerFactory.getLogger(ContentSourceDemultiplexer.class);
        private final AtomicBiInteger counters = new AtomicBiInteger();
        private final List<Response.ContentSourceListener> listeners = new ArrayList<Response.ContentSourceListener>(2);
        private final List<ContentSource> contentSources = new ArrayList<ContentSource>(2);
        private Content.Source originalContentSource;

        private ContentSourceDemultiplexer() {
        }

        private void addContentSourceListener(Response.ContentSourceListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void onContentSource(Response response, Content.Source contentSource) {
            this.originalContentSource = contentSource;
            for (int i = 0; i < this.listeners.size(); ++i) {
                Response.ContentSourceListener listener = this.listeners.get(i);
                ContentSource cs = new ContentSource(i);
                this.contentSources.add(cs);
                ResponseListeners.notifyContentSource(listener, response, cs);
            }
        }

        private void onDemandCallback() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original content source's demand calling back");
            }
            Content.Chunk chunk = this.originalContentSource.read();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read from original content source {}", (Object)chunk);
            }
            for (ContentSource demultiplexerContentSource : this.contentSources) {
                demultiplexerContentSource.onChunk(chunk);
            }
            chunk.release();
        }

        private void registerFailure(Throwable failure) {
            block3: {
                int demands;
                block2: {
                    int failures;
                    long encoded;
                    do {
                        encoded = this.counters.get();
                        failures = AtomicBiInteger.getHi((long)encoded) + 1;
                        demands = AtomicBiInteger.getLo((long)encoded);
                        if (demands != this.listeners.size() - failures) continue;
                        demands = 0;
                    } while (!this.counters.compareAndSet(encoded, failures, demands));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Registered failure; failures={} demands={}", (Object)failures, (Object)demands);
                    }
                    if (failures != this.listeners.size()) break block2;
                    this.originalContentSource.fail(failure);
                    break block3;
                }
                if (demands != 0) break block3;
                this.originalContentSource.demand(this::onDemandCallback);
            }
        }

        private void registerDemand() {
            block2: {
                int demands;
                int failures;
                long encoded;
                do {
                    encoded = this.counters.get();
                    failures = AtomicBiInteger.getHi((long)encoded);
                    demands = AtomicBiInteger.getLo((long)encoded) + 1;
                    if (demands != this.listeners.size() - failures) continue;
                    demands = 0;
                } while (!this.counters.compareAndSet(encoded, failures, demands));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registered demand; failures={} demands={}", (Object)failures, (Object)demands);
                }
                if (demands != 0) break block2;
                this.originalContentSource.demand(this::onDemandCallback);
            }
        }

        private class ContentSource
        implements Content.Source {
            private static final Content.Chunk ALREADY_READ_CHUNK = new Content.Chunk(){

                public ByteBuffer getByteBuffer() {
                    throw new UnsupportedOperationException();
                }

                public boolean isLast() {
                    throw new UnsupportedOperationException();
                }

                public boolean canRetain() {
                    throw new UnsupportedOperationException();
                }

                public void retain() {
                    throw new UnsupportedOperationException();
                }

                public boolean release() {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return "AlreadyReadChunk";
                }
            };
            private final int index;
            private final AtomicReference<Runnable> demandCallbackRef = new AtomicReference();
            private volatile Content.Chunk chunk;

            private ContentSource(int index) {
                this.index = index;
            }

            private void onChunk(Content.Chunk chunk) {
                Content.Chunk currentChunk = this.chunk;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registering content in multiplexed content source #{} that contains {}", (Object)this.index, (Object)currentChunk);
                }
                if (currentChunk == null || currentChunk == ALREADY_READ_CHUNK) {
                    if (chunk.hasRemaining()) {
                        chunk = Content.Chunk.asChunk((ByteBuffer)chunk.getByteBuffer().slice(), (boolean)chunk.isLast(), (Retainable)chunk);
                    }
                    chunk.retain();
                    this.chunk = chunk;
                } else if (!currentChunk.isLast()) {
                    throw new IllegalStateException("Cannot overwrite chunk");
                }
                this.onDemandCallback();
            }

            private void onDemandCallback() {
                Runnable callback = this.demandCallbackRef.getAndSet(null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} invoking demand callback {}", (Object)this.index, (Object)callback);
                }
                if (callback != null) {
                    try {
                        callback.run();
                    }
                    catch (Throwable x) {
                        this.fail(x);
                    }
                }
            }

            public Content.Chunk read() {
                if (this.chunk == ALREADY_READ_CHUNK) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Content source #{} already read current chunk", (Object)this.index);
                    }
                    return null;
                }
                Content.Chunk result = this.chunk;
                if (result != null) {
                    Content.Chunk chunk = this.chunk = result.isLast() ? Content.Chunk.next((Content.Chunk)result) : ALREADY_READ_CHUNK;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} reading current chunk {}", (Object)this.index, (Object)result);
                }
                return result;
            }

            public void demand(Runnable demandCallback) {
                if (!this.demandCallbackRef.compareAndSet(null, Objects.requireNonNull(demandCallback))) {
                    throw new IllegalStateException();
                }
                Content.Chunk currentChunk = this.chunk;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} demand while current chunk is {}", (Object)this.index, (Object)currentChunk);
                }
                if (currentChunk == null || currentChunk == ALREADY_READ_CHUNK) {
                    ContentSourceDemultiplexer.this.registerDemand();
                } else {
                    this.onDemandCallback();
                }
            }

            public void fail(Throwable failure) {
                Content.Chunk currentChunk = this.chunk;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} fail while current chunk is {}", (Object)this.index, (Object)currentChunk);
                }
                if (currentChunk instanceof Content.Chunk.Error) {
                    return;
                }
                if (currentChunk != null) {
                    currentChunk.release();
                }
                this.chunk = Content.Chunk.from((Throwable)failure);
                this.onDemandCallback();
                ContentSourceDemultiplexer.this.registerFailure(failure);
            }
        }
    }
}

