/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamResponseListener
implements Response.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamResponseListener.class);
    private static final ChunkCallback EOF = new ChunkCallback(Content.Chunk.EOF, () -> {}, x -> {});
    private final AutoLock.WithCondition lock = new AutoLock.WithCondition();
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<InputStream> stream = new AtomicReference();
    private final Queue<ChunkCallback> chunkCallbacks = new ArrayDeque<ChunkCallback>();
    private Response response;
    private Result result;
    private Throwable failure;
    private boolean closed;

    @Override
    public void onHeaders(Response response) {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            this.response = response;
            this.responseLatch.countDown();
        }
    }

    @Override
    public void onContent(Response response, Content.Chunk chunk, Runnable demander) {
        if (!chunk.hasRemaining()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped empty chunk {}", (Object)chunk);
            }
            demander.run();
            return;
        }
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (!this.closed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queueing chunk {}", (Object)chunk);
                }
                chunk.retain();
                this.chunkCallbacks.add(new ChunkCallback(chunk, demander, response::abort));
                l.signalAll();
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("InputStream closed, ignored chunk {}", (Object)chunk);
        }
        response.abort(new AsynchronousCloseException());
    }

    @Override
    public void onSuccess(Response response) {
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (!this.closed) {
                this.chunkCallbacks.add(EOF);
            }
            l.signalAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End of content");
        }
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        List<ChunkCallback> chunkCallbacks;
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (this.failure != null) {
                return;
            }
            this.failure = failure;
            chunkCallbacks = this.drain();
            l.signalAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content failure", failure);
        }
        chunkCallbacks.forEach(chunkCallback -> chunkCallback.releaseAndFail(failure));
    }

    @Override
    public void onComplete(Result result) {
        Throwable failure = result.getFailure();
        List<Object> chunkCallbacks = Collections.emptyList();
        try (AutoLock.WithCondition l = this.lock.lock();){
            this.result = result;
            if (result.isFailed() && this.failure == null) {
                this.failure = failure;
                chunkCallbacks = this.drain();
            }
            this.responseLatch.countDown();
            this.resultLatch.countDown();
            l.signalAll();
        }
        if (LOG.isDebugEnabled()) {
            if (failure == null) {
                LOG.debug("Result success");
            } else {
                LOG.debug("Result failure", failure);
            }
        }
        chunkCallbacks.forEach(t -> t.releaseAndFail(failure));
    }

    public Response get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean expired;
        boolean bl = expired = !this.responseLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.response == null) {
                throw new ExecutionException(this.failure);
            }
            Response response = this.response;
            return response;
        }
    }

    public Result await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.resultLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            Result result = this.result;
            return result;
        }
    }

    public InputStream getInputStream() {
        InputStream result = new Input();
        if (this.stream.compareAndSet(null, result)) {
            return result;
        }
        result = InputStream.nullInputStream();
        IO.close((InputStream)result);
        return result;
    }

    private List<ChunkCallback> drain() {
        ArrayList<ChunkCallback> failures = new ArrayList<ChunkCallback>();
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            ChunkCallback chunkCallback;
            while ((chunkCallback = this.chunkCallbacks.peek()) != null) {
                if (chunkCallback == EOF) {
                    break;
                }
                failures.add(chunkCallback);
                this.chunkCallbacks.poll();
            }
        }
        return failures;
    }

    private record ChunkCallback(Content.Chunk chunk, Runnable success, Consumer<Throwable> throwableConsumer) {
        private void releaseAndSucceed() {
            this.chunk.release();
            this.success.run();
        }

        private void releaseAndFail(Throwable x) {
            this.chunk.release();
            this.throwableConsumer.accept(x);
        }
    }

    private class Input
    extends InputStream {
        private Input() {
        }

        @Override
        public int read() throws IOException {
            byte[] tmp = new byte[1];
            int read = this.read(tmp);
            if (read < 0) {
                return read;
            }
            return tmp[0] & 0xFF;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            try {
                int result;
                ChunkCallback chunkCallback;
                block16: {
                    try (AutoLock.WithCondition l = InputStreamResponseListener.this.lock.lock();){
                        block15: {
                            while (true) {
                                if ((chunkCallback = InputStreamResponseListener.this.chunkCallbacks.peek()) == EOF) {
                                    int n = -1;
                                    return n;
                                }
                                if (chunkCallback != null) {
                                    ByteBuffer buffer = chunkCallback.chunk().getByteBuffer();
                                    result = Math.min(buffer.remaining(), length);
                                    buffer.get(b, offset, result);
                                    if (!buffer.hasRemaining()) {
                                        break;
                                    }
                                    break block15;
                                }
                                if (InputStreamResponseListener.this.failure != null) {
                                    throw new IOException(InputStreamResponseListener.this.failure);
                                }
                                if (InputStreamResponseListener.this.closed) {
                                    throw new AsynchronousCloseException();
                                }
                                l.await();
                            }
                            InputStreamResponseListener.this.chunkCallbacks.poll();
                            break block16;
                        }
                        chunkCallback = null;
                    }
                }
                if (chunkCallback == null) return result;
                chunkCallback.releaseAndSucceed();
                return result;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() throws IOException {
            List<ChunkCallback> chunkCallbacks;
            try (AutoLock.WithCondition l = InputStreamResponseListener.this.lock.lock();){
                if (InputStreamResponseListener.this.closed) {
                    return;
                }
                InputStreamResponseListener.this.closed = true;
                chunkCallbacks = InputStreamResponseListener.this.drain();
                l.signalAll();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream close");
            }
            AsynchronousCloseException failure = new AsynchronousCloseException();
            chunkCallbacks.forEach(t -> t.releaseAndFail(failure));
            super.close();
        }
    }
}

