/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.internal.HttpChannelOverHTTP;
import org.eclipse.jetty.client.transport.internal.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP.class);
    private final Runnable receiveNext = this::receiveNext;
    private final LongAdder inMessages = new LongAdder();
    private final HttpParser parser;
    private final ByteBufferPool byteBufferPool;
    private RetainableByteBuffer networkBuffer;
    private State state = State.STATUS;
    private boolean unsolicited;
    private int status;
    private String method;
    private Content.Chunk chunk;
    private boolean shutdown;
    private boolean disposed;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        HttpClient httpClient = channel.getHttpDestination().getHttpClient();
        this.parser = new HttpParser((HttpParser.ResponseHandler)this, httpClient.getMaxResponseHeadersSize(), httpClient.getHttpCompliance());
        HttpClientTransport transport = httpClient.getHttpClientTransport();
        if (transport instanceof HttpClientTransportOverHTTP) {
            HttpClientTransportOverHTTP httpTransport = (HttpClientTransportOverHTTP)transport;
            this.parser.setHeaderCacheSize(httpTransport.getHeaderCacheSize());
            this.parser.setHeaderCacheCaseSensitive(httpTransport.isHeaderCacheCaseSensitive());
        }
        this.byteBufferPool = httpClient.getByteBufferPool();
    }

    void receive() {
        if (!this.hasContent()) {
            boolean setFillInterest = this.parseAndFill(true);
            if (!this.hasContent() && setFillInterest) {
                this.fillInterested();
            }
        } else {
            HttpExchange exchange = this.getHttpExchange();
            if (exchange != null) {
                this.responseContentAvailable(exchange);
            }
        }
    }

    @Override
    protected void onInterim() {
        this.receive();
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
        if (this.chunk != null) {
            this.chunk.release();
        }
        this.chunk = null;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
        if (this.chunk != null) {
            this.chunk.release();
        }
        this.chunk = null;
        this.disposed = true;
    }

    @Override
    public Content.Chunk read(boolean fillInterestIfNeeded) {
        Content.Chunk chunk;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading, fillInterestIfNeeded={} in {}", (Object)fillInterestIfNeeded, (Object)this);
        }
        if ((chunk = this.consumeChunk()) != null) {
            return chunk;
        }
        boolean needFillInterest = this.parseAndFill(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ParseAndFill needFillInterest {} in {}", (Object)needFillInterest, (Object)this);
        }
        if ((chunk = this.consumeChunk()) != null) {
            return chunk;
        }
        if (needFillInterest && fillInterestIfNeeded) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read null, filled 0, fill interest requested -> call fillInterested in {}", (Object)this);
            }
            this.fillInterested();
        }
        return null;
    }

    private Content.Chunk consumeChunk() {
        Content.Chunk chunk = this.chunk;
        this.chunk = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receiver consuming chunk {} in {}", (Object)chunk, (Object)this);
        }
        return chunk;
    }

    @Override
    public void failAndClose(Throwable failure) {
        this.responseFailure(failure, (Promise<Boolean>)Promise.from(failed -> {
            if (failed.booleanValue()) {
                this.getHttpConnection().close(failure);
            }
        }, x -> this.getHttpConnection().close(failure)));
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected ByteBuffer getResponseBuffer() {
        return this.networkBuffer == null ? null : this.networkBuffer.getByteBuffer();
    }

    private void acquireNetworkBuffer() {
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired {} in {}", (Object)this.networkBuffer, (Object)this);
        }
    }

    private void reacquireNetworkBuffer() {
        RetainableByteBuffer currentBuffer = this.networkBuffer;
        if (currentBuffer == null) {
            throw new IllegalStateException();
        }
        if (currentBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        currentBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reacquired {} <- {} in {}", new Object[]{currentBuffer, this.networkBuffer, this});
        }
    }

    private RetainableByteBuffer newNetworkBuffer() {
        HttpClient client = this.getHttpDestination().getHttpClient();
        boolean direct = client.isUseInputDirectByteBuffers();
        return this.byteBufferPool.acquire(client.getResponseBufferSize(), direct);
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {} in {}", (Object)this.networkBuffer, (Object)this);
        }
        this.networkBuffer = null;
    }

    protected ByteBuffer onUpgradeFrom() {
        RetainableByteBuffer networkBuffer = this.networkBuffer;
        if (networkBuffer == null) {
            return null;
        }
        ByteBuffer upgradeBuffer = null;
        if (networkBuffer.hasRemaining()) {
            HttpClient client = this.getHttpDestination().getHttpClient();
            upgradeBuffer = BufferUtil.allocate((int)networkBuffer.remaining(), (boolean)client.isUseInputDirectByteBuffers());
            BufferUtil.clearToFill((ByteBuffer)upgradeBuffer);
            BufferUtil.put((ByteBuffer)networkBuffer.getByteBuffer(), (ByteBuffer)upgradeBuffer);
            BufferUtil.flipToFlush((ByteBuffer)upgradeBuffer, (int)0);
        }
        this.releaseNetworkBuffer();
        return upgradeBuffer;
    }

    private boolean parseAndFill(boolean notifyContentAvailable) {
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        EndPoint endPoint = connection.getEndPoint();
        try {
            if (this.networkBuffer == null) {
                this.acquireNetworkBuffer();
            }
            while (true) {
                boolean stopParsing = this.parse(notifyContentAvailable);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parsed stop={} in {}", (Object)stopParsing, (Object)this);
                }
                if (stopParsing) {
                    return false;
                }
                if (connection.isClosed() || this.isShutdown()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closed/Shutdown {} in {}", (Object)connection, (Object)this);
                    }
                    this.releaseNetworkBuffer();
                    return false;
                }
                if (this.networkBuffer.isRetained()) {
                    this.reacquireNetworkBuffer();
                }
                assert (!this.networkBuffer.hasRemaining());
                int read = endPoint.fill(this.networkBuffer.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes in {} from {} in {}", new Object[]{read, this.networkBuffer, endPoint, this});
                }
                if (read > 0) {
                    connection.addBytesIn(read);
                    continue;
                }
                if (read == 0) {
                    this.releaseNetworkBuffer();
                    return true;
                }
                this.shutdown();
            }
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error processing {} in {}", new Object[]{endPoint, this, x});
            }
            this.releaseNetworkBuffer();
            this.failAndClose(x);
            return false;
        }
    }

    private boolean parse(boolean notifyContentAvailable) {
        ByteBuffer byteBuffer = this.networkBuffer.getByteBuffer();
        block5: while (true) {
            boolean handle = this.parser.parseNext(byteBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse state={} result={} {} {} on {}", new Object[]{this.state, handle, BufferUtil.toDetailString((ByteBuffer)byteBuffer), this.parser, this});
            }
            if (!handle) {
                return false;
            }
            HttpExchange exchange = this.getHttpExchange();
            if (exchange == null) {
                throw new IllegalStateException("No exchange");
            }
            switch (this.state.ordinal()) {
                case 1: {
                    this.responseHeaders(exchange);
                    break block5;
                }
                case 2: {
                    if (!notifyContentAvailable) break block5;
                    this.responseContentAvailable(exchange);
                    break block5;
                }
                case 3: {
                    boolean isUpgrade = this.status == 101;
                    boolean isTunnel = this.getHttpChannel().isTunnel(this.method, this.status);
                    Runnable task = isUpgrade || isTunnel ? null : this.receiveNext;
                    this.responseSuccess(exchange, task);
                    if (isUpgrade || isTunnel) {
                        return true;
                    }
                    if (byteBuffer.hasRemaining()) {
                        if (HttpStatus.isInterim((int)this.status)) continue block5;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Discarding unexpected content after response {}: {} in {}", new Object[]{this.status, BufferUtil.toDetailString((ByteBuffer)byteBuffer), this});
                        }
                        BufferUtil.clear((ByteBuffer)byteBuffer);
                        return false;
                    }
                    return false;
                }
                default: {
                    throw new IllegalStateException("Invalid state " + String.valueOf((Object)this.state));
                }
            }
            break;
        }
        if (this.disposed) {
            BufferUtil.clear((ByteBuffer)byteBuffer);
            return false;
        }
        return true;
    }

    protected void fillInterested() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering as fill interested in {}", (Object)this);
        }
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    public void startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        boolean bl = this.unsolicited = exchange == null;
        if (exchange == null) {
            return;
        }
        this.method = exchange.getRequest().getMethod();
        this.status = status;
        this.parser.setHeadResponse(HttpMethod.HEAD.is(this.method) || this.getHttpChannel().isTunnel(this.method, status));
        exchange.getResponse().version(version).status(status).reason(reason);
        this.state = State.STATUS;
        this.responseBegin(exchange);
    }

    public void parsedHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return;
        }
        this.responseHeader(exchange, field);
    }

    public boolean headerComplete() {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return false;
        }
        exchange.getRequest().getConversation().setAttribute(EndPoint.class.getName(), this.getHttpConnection().getEndPoint());
        this.getHttpConnection().onResponseHeaders(exchange);
        this.state = State.HEADERS;
        return true;
    }

    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parser generated content {} in {}", (Object)BufferUtil.toDetailString((ByteBuffer)buffer), (Object)this);
        }
        this.unsolicited |= (exchange = this.getHttpExchange()) == null;
        if (this.unsolicited) {
            return false;
        }
        if (this.chunk != null) {
            throw new IllegalStateException("Content generated with unconsumed content left");
        }
        if (this.getHttpConnection().isFillInterested()) {
            throw new IllegalStateException("Fill interested while parsing for content");
        }
        this.networkBuffer.retain();
        this.chunk = Content.Chunk.asChunk((ByteBuffer)buffer, (boolean)false, (Retainable)this.networkBuffer);
        this.state = State.CONTENT;
        return true;
    }

    public boolean contentComplete() {
        return false;
    }

    public void parsedTrailer(HttpField trailer) {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending trailer '{}' to response in {}", (Object)trailer, (Object)this);
        }
        exchange.getResponse().trailer(trailer);
    }

    public boolean messageComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null || this.unsolicited) {
            this.networkBuffer.clear();
            this.getHttpConnection().close();
            return false;
        }
        int status = exchange.getResponse().getStatus();
        if (!HttpStatus.isInterim((int)status)) {
            this.inMessages.increment();
        }
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        this.chunk = Content.Chunk.EOF;
        this.state = State.COMPLETE;
        return true;
    }

    private void receiveNext() {
        if (this.hasContent()) {
            throw new IllegalStateException();
        }
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receiving next response in {}", (Object)this);
        }
        boolean setFillInterest = this.parseAndFill(true);
        if (!this.hasContent() && setFillInterest) {
            this.fillInterested();
        }
    }

    public void earlyEOF() {
        HttpExchange exchange = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (exchange == null || this.unsolicited) {
            connection.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(connection)));
        }
    }

    public void badMessage(HttpException failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null || this.unsolicited) {
            this.getHttpConnection().close();
        } else {
            HttpResponse response = exchange.getResponse();
            response.status(failure.getCode()).reason(failure.getReason());
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + String.valueOf(this.getHttpConnection()), response, (Throwable)failure));
        }
    }

    long getMessagesIn() {
        return this.inMessages.longValue();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }

    private static enum State {
        STATUS,
        HEADERS,
        CONTENT,
        COMPLETE;

    }
}

