/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.InputStreamResponseListener;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathResponseListener
extends CompletableFuture<PathResponse>
implements Response.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamResponseListener.class);
    private final Path path;
    private final FileChannel fileChannel;

    public PathResponseListener(Path path, boolean overwrite) throws IOException {
        this.path = path;
        if (Files.exists(path, new LinkOption[0]) && !overwrite) {
            throw new FileAlreadyExistsException(path.toString(), null, "File cannot be overwritten");
        }
        this.fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public void onHeaders(Response response) {
        if (response.getStatus() != 200) {
            response.abort(new HttpResponseException(String.format("Cannot save response content for HTTP status code %d", response.getStatus()), response));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("saving response content to {}", (Object)this.path);
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        try {
            int bytesWritten = this.fileChannel.write(content);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} bytes written to {}", (Object)bytesWritten, (Object)this.path);
            }
        }
        catch (Throwable x) {
            response.abort(x);
        }
    }

    @Override
    public void onSuccess(Response response) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("saved response content to {}", (Object)this.path);
        }
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to save response content to {}", (Object)this.path);
        }
    }

    @Override
    public void onComplete(Result result) {
        IO.close((Closeable)this.fileChannel);
        if (result.isSucceeded()) {
            this.complete(new PathResponse(result.getResponse(), this.path));
        } else {
            this.completeExceptionally(result.getFailure());
        }
    }

    public static CompletableFuture<PathResponse> write(Request request, Path path, boolean overwrite) {
        PathResponseListener listener = null;
        try {
            listener = new PathResponseListener(path, overwrite);
            request.send(listener);
            return listener;
        }
        catch (Throwable x) {
            CompletableFuture<PathResponse> completable = Objects.requireNonNullElse(listener, new CompletableFuture());
            completable.completeExceptionally(x);
            return completable;
        }
    }

    public record PathResponse(Response response, Path path) {
    }
}

