/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.SelectConnector;
import org.eclipse.jetty.client.SocketConnector;
import org.eclipse.jetty.client.security.Authorization;
import org.eclipse.jetty.client.security.RealmResolver;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient
extends HttpBuffers
implements Attributes {
    public static final int CONNECTOR_SOCKET = 0;
    public static final int CONNECTOR_SELECT_CHANNEL = 2;
    private int _connectorType = 2;
    private boolean _useDirectBuffers = true;
    private int _maxConnectionsPerAddress = Integer.MAX_VALUE;
    private Map<Address, HttpDestination> _destinations = new HashMap<Address, HttpDestination>();
    ThreadPool _threadPool;
    Connector _connector;
    private long _idleTimeout = 20000L;
    private long _timeout = 320000L;
    int _soTimeout = 10000;
    private Timeout _timeoutQ = new Timeout();
    private Address _proxy;
    private Authorization _proxyAuthentication;
    private Set<String> _noProxy;
    private int _maxRetries = 3;
    private LinkedList<String> _registeredListeners;
    private String _keyStoreLocation;
    private String _keyStoreType = "JKS";
    private String _keyStorePassword;
    private String _keyManagerAlgorithm = "SunX509";
    private String _keyManagerPassword;
    private String _trustStoreLocation;
    private String _trustStoreType = "JKS";
    private String _trustStorePassword;
    private String _trustManagerAlgorithm = "SunX509";
    private SSLContext _sslContext;
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private RealmResolver _realmResolver;
    private AttributesMap _attributes = new AttributesMap();

    public void dump() {
        try {
            for (Map.Entry<Address, HttpDestination> entry : this._destinations.entrySet()) {
                Log.info((String)("\n" + entry.getKey() + ":"));
                entry.getValue().dump();
            }
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
    }

    public void send(HttpExchange exchange) throws IOException {
        boolean ssl = HttpSchemes.HTTPS_BUFFER.equalsIgnoreCase(exchange.getScheme());
        exchange.setStatus(1);
        HttpDestination destination = this.getDestination(exchange.getAddress(), ssl);
        destination.send(exchange);
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpDestination getDestination(Address remote, boolean ssl) throws UnknownHostException, IOException {
        if (remote == null) {
            throw new UnknownHostException("Remote socket address cannot be null.");
        }
        Map<Address, HttpDestination> map = this._destinations;
        synchronized (map) {
            HttpDestination destination = this._destinations.get(remote);
            if (destination == null) {
                destination = new HttpDestination(this, remote, ssl, this._maxConnectionsPerAddress);
                if (!(this._proxy == null || this._noProxy != null && this._noProxy.contains(remote.getHost()))) {
                    destination.setProxy(this._proxy);
                    if (this._proxyAuthentication != null) {
                        destination.setProxyAuthentication(this._proxyAuthentication);
                    }
                }
                this._destinations.put(remote, destination);
            }
            return destination;
        }
    }

    public void schedule(Timeout.Task task) {
        this._timeoutQ.schedule(task);
    }

    public void cancel(Timeout.Task task) {
        task.cancel();
    }

    public boolean getUseDirectBuffers() {
        return this._useDirectBuffers;
    }

    public void setRealmResolver(RealmResolver resolver) {
        this._realmResolver = resolver;
    }

    public RealmResolver getRealmResolver() {
        return this._realmResolver;
    }

    public boolean hasRealms() {
        return this._realmResolver != null;
    }

    public void registerListener(String listenerClass) {
        if (this._registeredListeners == null) {
            this._registeredListeners = new LinkedList();
        }
        this._registeredListeners.add(listenerClass);
    }

    public LinkedList<String> getRegisteredListeners() {
        return this._registeredListeners;
    }

    public void setUseDirectBuffers(boolean direct) {
        this._useDirectBuffers = direct;
    }

    public int getConnectorType() {
        return this._connectorType;
    }

    public void setConnectorType(int connectorType) {
        this._connectorType = connectorType;
    }

    protected Buffer newRequestBuffer(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return this._useDirectBuffers ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
    }

    protected Buffer newRequestHeader(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return new IndirectNIOBuffer(size);
    }

    protected Buffer newResponseBuffer(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return this._useDirectBuffers ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
    }

    protected Buffer newResponseHeader(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return new IndirectNIOBuffer(size);
    }

    public int getMaxConnectionsPerAddress() {
        return this._maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this._maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._timeoutQ.setNow();
        this._timeoutQ.setDuration(this._timeout);
        if (this._threadPool == null) {
            QueuedThreadPool pool = new QueuedThreadPool();
            pool.setMaxThreads(16);
            pool.setDaemon(true);
            pool.setName("HttpClient");
            this._threadPool = pool;
        }
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).start();
        }
        this._connector = this._connectorType == 2 ? new SelectConnector(this) : new SocketConnector(this);
        this._connector.start();
        this._threadPool.dispatch(new Runnable(){

            public void run() {
                while (HttpClient.this.isRunning()) {
                    HttpClient.this._timeoutQ.setNow();
                    HttpClient.this._timeoutQ.tick();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    protected void doStop() throws Exception {
        this._connector.stop();
        this._connector = null;
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).stop();
        }
        for (HttpDestination destination : this._destinations.values()) {
            destination.close();
        }
        this._timeoutQ.cancelAll();
        super.doStop();
    }

    protected SSLContext getSSLContext() throws IOException {
        if (this._sslContext == null) {
            this._sslContext = this._keyStoreLocation == null ? this.getLooseSSLContext() : this.getStrictSSLContext();
        }
        return this._sslContext;
    }

    protected SSLContext getStrictSSLContext() throws IOException {
        try {
            if (this._trustStoreLocation == null) {
                this._trustStoreLocation = this._keyStoreLocation;
                this._trustStoreType = this._keyStoreType;
            }
            KeyManager[] keyManagers = null;
            InputStream keystoreInputStream = null;
            keystoreInputStream = Resource.newResource((String)this._keyStoreLocation).getInputStream();
            KeyStore keyStore = KeyStore.getInstance(this._keyStoreType);
            keyStore.load(keystoreInputStream, this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? null : this._keyManagerPassword.toString().toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            InputStream truststoreInputStream = null;
            truststoreInputStream = Resource.newResource((String)this._trustStoreLocation).getInputStream();
            KeyStore trustStore = KeyStore.getInstance(this._trustStoreType);
            trustStore.load(truststoreInputStream, this._trustStorePassword == null ? null : this._trustStorePassword.toString().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
            SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
            context.init(keyManagers, trustManagers, secureRandom);
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("error generating ssl context for " + this._keyStoreLocation + " " + e.getMessage());
        }
    }

    protected SSLContext getLooseSSLContext() throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                Log.warn((String)("Warning: URL Host: " + urlHostName + " vs." + session.getPeerHost()));
                return true;
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new IOException("issue ignoring certs");
        }
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long ms) {
        this._idleTimeout = ms;
    }

    public int getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(int so) {
        this._soTimeout = so;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long ms) {
        this._timeout = ms;
    }

    public Address getProxy() {
        return this._proxy;
    }

    public void setProxy(Address proxy) {
        this._proxy = proxy;
    }

    public Authorization getProxyAuthentication() {
        return this._proxyAuthentication;
    }

    public void setProxyAuthentication(Authorization authentication) {
        this._proxyAuthentication = authentication;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    public Set<String> getNoProxy() {
        return this._noProxy;
    }

    public void setNoProxy(Set<String> noProxyAddresses) {
        this._noProxy = noProxyAddresses;
    }

    public int maxRetries() {
        return this._maxRetries;
    }

    public void setMaxRetries(int retries) {
        this._maxRetries = retries;
    }

    public String getTrustStoreLocation() {
        return this._trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this._trustStoreLocation = trustStoreLocation;
    }

    public String getKeyStoreLocation() {
        return this._keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this._keyStoreLocation = keyStoreLocation;
    }

    public void setKeyStorePassword(String _keyStorePassword) {
        this._keyStorePassword = _keyStorePassword;
    }

    public void setKeyManagerPassword(String _keyManagerPassword) {
        this._keyManagerPassword = _keyManagerPassword;
    }

    public void setTrustStorePassword(String _trustStorePassword) {
        this._trustStorePassword = _trustStorePassword;
    }

    static interface Connector
    extends LifeCycle {
        public void startConnection(HttpDestination var1) throws IOException;
    }
}

