/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.http.ssl.SslSelectChannelEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

class SelectConnector
extends AbstractLifeCycle
implements HttpClient.Connector,
Runnable {
    private final HttpClient _httpClient;
    private SSLContext _sslContext;
    private Buffers _sslBuffers;
    private boolean _blockingConnect;
    Manager _selectorManager = new Manager();

    SelectConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public boolean isBlockingConnect() {
        return this._blockingConnect;
    }

    public void setBlockingConnect(boolean blockingConnect) {
        this._blockingConnect = blockingConnect;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._selectorManager.start();
        final boolean direct = this._httpClient.getUseDirectBuffers();
        SSLEngine sslEngine = this._selectorManager.newSslEngine();
        final SSLSession ssl_session = sslEngine.getSession();
        ThreadLocalBuffers ssl_buffers = new ThreadLocalBuffers(){
            {
                super.setBufferSize(ssl_session.getApplicationBufferSize());
                super.setHeaderSize(ssl_session.getApplicationBufferSize());
            }

            protected Buffer newBuffer(int size) {
                return direct ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }

            protected Buffer newHeader(int size) {
                return direct ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }

            protected boolean isHeader(Buffer buffer) {
                return true;
            }

            public void setBufferSize(int size) {
            }

            public void setHeaderSize(int size) {
            }
        };
        this._sslBuffers = ssl_buffers;
        this._httpClient._threadPool.dispatch((Runnable)this);
    }

    protected void doStop() throws Exception {
        this._selectorManager.stop();
    }

    public void startConnection(HttpDestination destination) throws IOException {
        SocketChannel channel = SocketChannel.open();
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        channel.configureBlocking(false);
        channel.connect(address.toSocketAddress());
        this._selectorManager.register(channel, destination);
    }

    public void run() {
        while (this._httpClient.isRunning()) {
            try {
                this._selectorManager.doSelect(0);
            }
            catch (Exception e) {
                Log.warn((String)e.toString());
                Log.debug((Throwable)e);
                Thread.yield();
            }
        }
    }

    class Manager
    extends SelectorManager {
        Manager() {
        }

        protected SocketChannel acceptChannel(SelectionKey key) throws IOException {
            throw new IllegalStateException();
        }

        public boolean dispatch(Runnable task) {
            return ((SelectConnector)SelectConnector.this)._httpClient._threadPool.dispatch(task);
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            if (endpoint instanceof SslSelectChannelEndPoint) {
                return new HttpConnection(SelectConnector.this._sslBuffers, SelectConnector.this._sslBuffers, (EndPoint)endpoint);
            }
            return new HttpConnection(SelectConnector.this._httpClient.getRequestBuffers(), SelectConnector.this._httpClient.getResponseBuffers(), (EndPoint)endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            HttpDestination dest = (HttpDestination)key.attachment();
            SelectChannelEndPoint ep = null;
            if (dest.isSecure()) {
                if (dest.isProxied()) {
                    String connect = "CONNECT " + dest.getAddress() + "HTTP/1.0" + "\r\n\r\n";
                    throw new IllegalStateException("Not Implemented");
                }
                SSLEngine engine = this.newSslEngine();
                ep = new SslSelectChannelEndPoint(SelectConnector.this._sslBuffers, channel, selectSet, key, engine);
            } else {
                ep = new SelectChannelEndPoint(channel, selectSet, key);
            }
            HttpConnection connection = (HttpConnection)ep.getConnection();
            connection.setDestination(dest);
            dest.onNewConnection(connection);
            return ep;
        }

        private synchronized SSLEngine newSslEngine() throws IOException {
            if (SelectConnector.this._sslContext == null) {
                SelectConnector.this._sslContext = SelectConnector.this._httpClient.getSSLContext();
            }
            SSLEngine sslEngine = SelectConnector.this._sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            sslEngine.beginHandshake();
            return sslEngine;
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (attachment instanceof HttpDestination) {
                ((HttpDestination)attachment).onConnectionFailed(ex);
            } else {
                super.connectionFailed(channel, ex, attachment);
            }
        }
    }
}

