/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.ssl.SslSelectChannelEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpConnection
implements Connection {
    private HttpDestination _destination;
    private EndPoint _endp;
    private HttpGenerator _generator;
    private HttpParser _parser;
    private boolean _http11 = true;
    private Buffer _connectionHeader;
    private Buffer _requestContentChunk;
    private boolean _requestComplete;
    private boolean _reserved;
    private volatile HttpExchange _exchange;
    private HttpExchange _pipeline;
    private final Timeout.Task _timeout = new TimeoutTask();
    private AtomicBoolean _idle = new AtomicBoolean(false);

    public void dump() throws IOException {
        Log.info((String)("endp=" + this._endp + " " + this._endp.isBufferingInput() + " " + this._endp.isBufferingOutput()));
        Log.info((String)("generator=" + this._generator));
        Log.info((String)("parser=" + this._parser.getState() + " " + this._parser.isMoreInBuffer()));
        Log.info((String)("exchange=" + this._exchange));
        if (this._endp instanceof SslSelectChannelEndPoint) {
            ((SslSelectChannelEndPoint)this._endp).dump();
        }
    }

    HttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endp) {
        this._endp = endp;
        this._generator = new HttpGenerator(requestBuffers, endp);
        this._parser = new HttpParser(responseBuffers, endp, (HttpParser.EventHandler)new Handler());
    }

    public long getTimeStamp() {
        return -1L;
    }

    public void setReserved(boolean reserved) {
        this._reserved = reserved;
    }

    public boolean isReserved() {
        return this._reserved;
    }

    public HttpDestination getDestination() {
        return this._destination;
    }

    public void setDestination(HttpDestination destination) {
        this._destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(HttpExchange ex) throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._exchange != null) {
                if (this._pipeline != null) {
                    throw new IllegalStateException(this + " PIPELINED!!!  _exchange=" + this._exchange);
                }
                this._pipeline = ex;
                return true;
            }
            if (!this._endp.isOpen()) {
                return false;
            }
            this._exchange = ex;
            this._exchange.setStatus(2);
            if (this._endp.isBlocking()) {
                this.notify();
            } else {
                SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
                scep.scheduleWrite();
            }
            this._destination.getHttpClient().schedule(this._timeout);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection handle() throws IOException {
        if (this._exchange != null) {
            this._exchange.associate(this);
        }
        try {
            int no_progress = 0;
            long flushed = 0L;
            boolean failed = false;
            while (this._endp.isBufferingInput() || this._endp.isOpen()) {
                HttpConnection httpConnection = this;
                synchronized (httpConnection) {
                    while (this._exchange == null) {
                        if (this._endp.isBlocking()) {
                            try {
                                this.wait();
                                continue;
                            }
                            catch (InterruptedException e) {
                                throw new InterruptedIOException();
                            }
                        }
                        this._parser.fill();
                        this._parser.skipCRLF();
                        if (this._parser.isMoreInBuffer()) {
                            Log.warn((String)"Unexpected data received but no request sent");
                            this.close();
                        }
                        HttpConnection e = this;
                        return e;
                    }
                    if (!this._exchange.isAssociated()) {
                        this._exchange.associate(this);
                    }
                }
                if (this._exchange.getStatus() == 2) {
                    no_progress = 0;
                    this.commitRequest();
                }
                try {
                    long io = 0L;
                    this._endp.flush();
                    if (this._generator.isComplete()) {
                        if (!this._requestComplete) {
                            this._requestComplete = true;
                            this._exchange.getEventListener().onRequestComplete();
                        }
                    } else {
                        HttpConnection httpConnection2 = this;
                        synchronized (httpConnection2) {
                            block76: {
                                if (this._exchange != null) break block76;
                                continue;
                            }
                            flushed = this._generator.flushBuffer();
                            io += flushed;
                        }
                        if (!this._generator.isComplete()) {
                            InputStream in = this._exchange.getRequestContentSource();
                            if (in != null) {
                                if (this._requestContentChunk == null || this._requestContentChunk.length() == 0) {
                                    this._requestContentChunk = this._exchange.getRequestContentChunk();
                                    if (this._requestContentChunk != null) {
                                        this._generator.addContent(this._requestContentChunk, false);
                                    } else {
                                        this._generator.complete();
                                    }
                                    io += this._generator.flushBuffer();
                                }
                            } else {
                                this._generator.complete();
                            }
                        }
                    }
                    if (this._generator.isComplete() && !this._requestComplete) {
                        this._requestComplete = true;
                        this._exchange.getEventListener().onRequestComplete();
                    }
                    if (!this._parser.isComplete() && this._generator.isCommitted()) {
                        long filled = this._parser.parseAvailable();
                        io += filled;
                    }
                    if (io > 0L) {
                        no_progress = 0;
                        continue;
                    }
                    if (no_progress++ < 2 || this._endp.isBlocking() || this._endp instanceof SslSelectChannelEndPoint && !this._generator.isComplete() && !this._generator.isEmpty() && this._generator.flushBuffer() > 0L) continue;
                    HttpConnection httpConnection3 = this;
                    return httpConnection3;
                }
                catch (Throwable e) {
                    Log.debug((String)("Failure on " + this._exchange), (Object)e);
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    HttpConnection httpConnection4 = this;
                    synchronized (httpConnection4) {
                        if (this._exchange != null && this._exchange.getStatus() != 10) {
                            this._exchange.setStatus(9);
                            this._exchange.getEventListener().onException(e);
                        }
                    }
                    failed = true;
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    boolean complete = false;
                    boolean close = failed;
                    if (!failed && this._generator.isComplete()) {
                        if (!this._requestComplete) {
                            this._requestComplete = true;
                            this._exchange.getEventListener().onRequestComplete();
                        }
                        if (this._parser.isComplete()) {
                            this._destination.getHttpClient().cancel(this._timeout);
                            complete = true;
                        }
                    }
                    if (!complete && !failed) continue;
                    HttpConnection httpConnection5 = this;
                    synchronized (httpConnection5) {
                        if (!close) {
                            close = this.shouldClose();
                        }
                        this.reset(true);
                        no_progress = 0;
                        if (this._exchange != null) {
                            HttpExchange exchange;
                            this._exchange.disassociate();
                            this._exchange = null;
                            if (this._pipeline == null) {
                                if (!this.isReserved()) {
                                    this._destination.returnConnection(this, close);
                                }
                            } else if (close) {
                                if (!this.isReserved()) {
                                    this._destination.returnConnection(this, close);
                                }
                                exchange = this._pipeline;
                                this._pipeline = null;
                                this._destination.send(exchange);
                            } else {
                                exchange = this._pipeline;
                                this._pipeline = null;
                                this.send(exchange);
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (this._exchange != null && this._exchange.isAssociated()) {
                this._exchange.disassociate();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            return this._exchange == null;
        }
    }

    public boolean isSuspended() {
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRequest() throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            Buffer requestContent;
            if (this._exchange.getStatus() != 2) {
                throw new IllegalStateException();
            }
            this._exchange.setStatus(3);
            this._generator.setVersion(this._exchange.getVersion());
            String uri = this._exchange.getURI();
            if (this._destination.isProxied() && uri.startsWith("/")) {
                uri = (this._destination.isSecure() ? "https" : "http") + "://" + this._destination.getAddress().getHost() + ":" + this._destination.getAddress().getPort() + uri;
                Authentication auth = this._destination.getProxyAuthentication();
                if (auth != null) {
                    auth.setCredentials(this._exchange);
                }
            }
            String method = this._exchange.getMethod();
            this._generator.setRequest(method, uri);
            this._parser.setHeadResponse("HEAD".equalsIgnoreCase(method));
            HttpFields requestHeaders = this._exchange.getRequestFields();
            if (this._exchange.getVersion() >= 11 && !requestHeaders.containsKey(HttpHeaders.HOST_BUFFER)) {
                requestHeaders.add(HttpHeaders.HOST_BUFFER, this._destination.getHostHeader());
            }
            if ((requestContent = this._exchange.getRequestContent()) != null) {
                requestHeaders.putLongField("Content-Length", (long)requestContent.length());
                this._generator.completeHeader(requestHeaders, false);
                this._generator.addContent(requestContent, true);
            } else {
                InputStream requestContentStream = this._exchange.getRequestContentSource();
                if (requestContentStream != null) {
                    this._generator.completeHeader(requestHeaders, false);
                    int available = requestContentStream.available();
                    if (available > 0) {
                        byte[] buf = new byte[available];
                        int length = requestContentStream.read(buf);
                        this._generator.addContent((Buffer)new ByteArrayBuffer(buf, 0, length), false);
                    }
                } else {
                    requestHeaders.remove("Content-Length");
                    this._generator.completeHeader(requestHeaders, true);
                }
            }
            this._exchange.setStatus(4);
        }
    }

    protected void reset(boolean returnBuffers) throws IOException {
        this._requestComplete = false;
        this._connectionHeader = null;
        this._parser.reset(returnBuffers);
        this._generator.reset(returnBuffers);
        this._http11 = true;
    }

    private boolean shouldClose() {
        if (this._connectionHeader != null) {
            if (HttpHeaderValues.CLOSE_BUFFER.equals(this._connectionHeader)) {
                return true;
            }
            if (HttpHeaderValues.KEEP_ALIVE_BUFFER.equals(this._connectionHeader)) {
                return false;
            }
        }
        return !this._http11;
    }

    public String toString() {
        return "HttpConnection@" + this.hashCode() + "//" + this._destination.getAddress().getHost() + ":" + this._destination.getAddress().getPort();
    }

    public String toDetailString() {
        return this.toString() + " ex=" + this._exchange + " " + this._timeout.getAge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this._endp.close();
        }
        finally {
            int status;
            HttpExchange exchange = this._exchange;
            if (exchange != null && (status = exchange.getStatus()) > 0 && status < 7) {
                System.err.println("\nCLOSE " + exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTimeout() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (!this._idle.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            this._destination.getHttpClient().scheduleIdle(this._timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelIdleTimeout() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._idle.compareAndSet(true, false)) {
                this._destination.getHttpClient().cancel(this._timeout);
                return true;
            }
        }
        return false;
    }

    private class TimeoutTask
    extends Timeout.Task {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expired() {
            HttpExchange ex = null;
            try {
                HttpConnection httpConnection = HttpConnection.this;
                synchronized (httpConnection) {
                    ex = HttpConnection.this._exchange;
                    HttpConnection.this._exchange = null;
                    if (ex != null) {
                        ex.disassociate();
                        HttpConnection.this._destination.returnConnection(HttpConnection.this, true);
                    } else if (HttpConnection.this._idle.compareAndSet(true, false)) {
                        HttpConnection.this._destination.returnIdleConnection(HttpConnection.this);
                    }
                }
            }
            catch (Exception e) {
                Log.debug((Throwable)e);
            }
            finally {
                try {
                    HttpConnection.this.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                if (ex != null && ex.getStatus() < 7) {
                    ex.setStatus(8);
                }
            }
        }
    }

    private class Handler
    extends HttpParser.EventHandler {
        private Handler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                HttpConnection.this._http11 = HttpVersions.HTTP_1_1_BUFFER.equals(version);
                exchange.getEventListener().onResponseStatus(version, status, reason);
                exchange.setStatus(5);
            }
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                if (HttpHeaders.CACHE.getOrdinal(name) == 1) {
                    HttpConnection.this._connectionHeader = HttpHeaderValues.CACHE.lookup(value);
                }
                exchange.getEventListener().onResponseHeader(name, value);
            }
        }

        public void headerComplete() throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                exchange.setStatus(6);
            }
        }

        public void content(Buffer ref) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                exchange.getEventListener().onResponseContent(ref);
            }
        }

        public void messageComplete(long contextLength) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                exchange.setStatus(7);
            }
        }
    }
}

