/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.log.Log;

public class HttpExchange {
    public static final int STATUS_START = 0;
    public static final int STATUS_WAITING_FOR_CONNECTION = 1;
    public static final int STATUS_WAITING_FOR_COMMIT = 2;
    public static final int STATUS_SENDING_REQUEST = 3;
    public static final int STATUS_WAITING_FOR_RESPONSE = 4;
    public static final int STATUS_PARSING_HEADERS = 5;
    public static final int STATUS_PARSING_CONTENT = 6;
    public static final int STATUS_COMPLETED = 7;
    public static final int STATUS_EXPIRED = 8;
    public static final int STATUS_EXCEPTED = 9;
    public static final int STATUS_CANCELLING = 10;
    public static final int STATUS_CANCELLED = 11;
    private String _method = "GET";
    private Buffer _scheme = HttpSchemes.HTTP_BUFFER;
    private String _uri;
    private int _version = 11;
    private Address _address;
    private final HttpFields _requestFields = new HttpFields();
    private Buffer _requestContent;
    private InputStream _requestContentSource;
    private AtomicInteger _status = new AtomicInteger(0);
    private Buffer _requestContentChunk;
    private boolean _retryStatus = false;
    private boolean _configureListeners = true;
    private HttpEventListener _listener = new Listener();
    private volatile HttpConnection _connection;
    boolean _onRequestCompleteDone;
    boolean _onResponseCompleteDone;
    boolean _onDone;

    public int getStatus() {
        return this._status.get();
    }

    @Deprecated
    public void waitForStatus(int status) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForDone() throws InterruptedException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            while (!this.isDone()) {
                this.wait();
            }
            return this._status.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this._onRequestCompleteDone = false;
            this._onResponseCompleteDone = false;
            this._onDone = false;
            this.setStatus(0);
        }
    }

    void setStatus(int newStatus) {
        try {
            int oldStatus = this._status.get();
            boolean set = false;
            block1 : switch (oldStatus) {
                case 0: {
                    switch (newStatus) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (newStatus) {
                        case 2: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (newStatus) {
                        case 3: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onExpire();
                        }
                    }
                    break;
                }
                case 3: {
                    switch (newStatus) {
                        case 4: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onRequestCommitted();
                            break;
                        }
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onExpire();
                        }
                    }
                    break;
                }
                case 4: {
                    switch (newStatus) {
                        case 5: 
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onExpire();
                        }
                    }
                    break;
                }
                case 5: {
                    switch (newStatus) {
                        case 6: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onResponseHeaderComplete();
                            break;
                        }
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onExpire();
                        }
                    }
                    break;
                }
                case 6: {
                    switch (newStatus) {
                        case 7: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onResponseComplete();
                            break;
                        }
                        case 9: 
                        case 10: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break;
                            this.getEventListener().onExpire();
                        }
                    }
                    break;
                }
                case 7: {
                    switch (newStatus) {
                        case 0: 
                        case 9: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            break;
                        }
                        case 8: 
                        case 10: {
                            set = true;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (newStatus) {
                        case 11: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                            if (!set) break block1;
                            this.done();
                            break;
                        }
                        default: {
                            set = true;
                            break;
                        }
                    }
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    switch (newStatus) {
                        case 0: {
                            set = this._status.compareAndSet(oldStatus, newStatus);
                        }
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)(oldStatus + " => " + newStatus));
                }
            }
            if (!set) {
                throw new IllegalStateException(oldStatus + " => " + newStatus);
            }
        }
        catch (IOException x) {
            Log.warn((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this._onDone;
        }
    }

    public HttpEventListener getEventListener() {
        return this._listener;
    }

    public void setEventListener(HttpEventListener listener) {
        this._listener = listener;
    }

    public void setURL(String url) {
        int port;
        HttpURI uri = new HttpURI(url);
        String scheme = uri.getScheme();
        if (scheme != null) {
            if ("http".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTP_BUFFER);
            } else if ("https".equalsIgnoreCase(scheme)) {
                this.setScheme(HttpSchemes.HTTPS_BUFFER);
            } else {
                this.setScheme((Buffer)new ByteArrayBuffer(scheme));
            }
        }
        if ((port = uri.getPort()) <= 0) {
            port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
        }
        this.setAddress(new Address(uri.getHost(), port));
        String completePath = uri.getCompletePath();
        if (completePath == null) {
            completePath = "/";
        }
        this.setURI(completePath);
    }

    public void setAddress(Address address) {
        this._address = address;
    }

    public Address getAddress() {
        return this._address;
    }

    public void setScheme(Buffer scheme) {
        this._scheme = scheme;
    }

    public Buffer getScheme() {
        return this._scheme;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void setVersion(String version) {
        BufferCache.CachedBuffer v = HttpVersions.CACHE.get(version);
        this._version = v == null ? 10 : v.getOrdinal();
    }

    public int getVersion() {
        return this._version;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public String getURI() {
        return this._uri;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public void addRequestHeader(String name, String value) {
        this.getRequestFields().add(name, value);
    }

    public void addRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().add(name, value);
    }

    public void setRequestHeader(String name, String value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestHeader(Buffer name, Buffer value) {
        this.getRequestFields().put(name, value);
    }

    public void setRequestContentType(String value) {
        this.getRequestFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, value);
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public void setRequestContent(Buffer requestContent) {
        this._requestContent = requestContent;
        this._requestContent.mark(this._requestContent.getIndex());
    }

    public void setRequestContentSource(InputStream stream) {
        this._requestContentSource = stream;
        if (this._requestContentSource.markSupported()) {
            this._requestContentSource.mark(Integer.MAX_VALUE);
        }
    }

    public InputStream getRequestContentSource() {
        return this._requestContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getRequestContentChunk() throws IOException {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this._requestContentChunk == null) {
                this._requestContentChunk = new ByteArrayBuffer(4096);
            } else {
                if (this._requestContentChunk.hasContent()) {
                    throw new IllegalStateException();
                }
                this._requestContentChunk.clear();
            }
            int read = this._requestContentChunk.capacity();
            int length = this._requestContentSource.read(this._requestContentChunk.array(), 0, read);
            if (length >= 0) {
                this._requestContentChunk.setPutIndex(length);
                return this._requestContentChunk;
            }
            return null;
        }
    }

    public Buffer getRequestContent() {
        return this._requestContent;
    }

    public boolean getRetryStatus() {
        return this._retryStatus;
    }

    public void setRetryStatus(boolean retryStatus) {
        this._retryStatus = retryStatus;
    }

    public void cancel() {
        this.setStatus(10);
        this.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this.disassociate();
            this._onDone = true;
            this.notifyAll();
        }
    }

    private void abort() {
        HttpConnection httpConnection = this._connection;
        if (httpConnection != null) {
            try {
                httpConnection.close();
            }
            catch (IOException x) {
                Log.debug((Throwable)x);
            }
        }
    }

    void associate(HttpConnection connection) {
        this._connection = connection;
        if (this.getStatus() == 10) {
            this.abort();
        }
    }

    boolean isAssociated() {
        return this._connection != null;
    }

    HttpConnection disassociate() {
        HttpConnection result = this._connection;
        this._connection = null;
        if (this.getStatus() == 10) {
            this.setStatus(11);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode() + "=" + this._method + "//" + this._address + this._uri + "#" + this.getStatus();
    }

    protected void onRequestCommitted() throws IOException {
    }

    protected void onRequestComplete() throws IOException {
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
    }

    protected void onResponseHeaderComplete() throws IOException {
    }

    protected void onResponseContent(Buffer content) throws IOException {
    }

    protected void onResponseComplete() throws IOException {
    }

    protected void onConnectionFailed(Throwable x) {
        Log.warn((String)("CONNECTION FAILED " + this), (Throwable)x);
    }

    protected void onException(Throwable x) {
        Log.warn((String)("EXCEPTION " + this), (Throwable)x);
    }

    protected void onExpire() {
        Log.warn((String)("EXPIRED " + this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onRetry() throws IOException {
        if (this._requestContentSource != null) {
            if (!this._requestContentSource.markSupported()) throw new IOException("Unsupported retry attempt");
            this._requestContent = null;
            this._requestContentSource.reset();
            return;
        } else {
            if (this._requestContent == null) return;
            this._requestContent.reset();
        }
    }

    public boolean configureListeners() {
        return this._configureListeners;
    }

    public void setConfigureListeners(boolean autoConfigure) {
        this._configureListeners = autoConfigure;
    }

    @Deprecated
    public static class ContentExchange
    extends org.eclipse.jetty.client.ContentExchange {
    }

    @Deprecated
    public static class CachedExchange
    extends org.eclipse.jetty.client.CachedExchange {
        public CachedExchange(boolean cacheFields) {
            super(cacheFields);
        }
    }

    private class Listener
    implements HttpEventListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(Throwable ex) {
            try {
                HttpExchange.this.onConnectionFailed(ex);
            }
            finally {
                HttpExchange.this.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Throwable ex) {
            try {
                HttpExchange.this.onException(ex);
            }
            finally {
                HttpExchange.this.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExpire() {
            try {
                HttpExchange.this.onExpire();
            }
            finally {
                HttpExchange.this.done();
            }
        }

        @Override
        public void onRequestCommitted() throws IOException {
            HttpExchange.this.onRequestCommitted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestComplete() throws IOException {
            try {
                HttpExchange.this.onRequestComplete();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onRequestCompleteDone = true;
                    HttpExchange.this._onDone = HttpExchange.this._onResponseCompleteDone;
                    if (HttpExchange.this._onDone) {
                        HttpExchange.this.disassociate();
                    }
                    HttpExchange.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponseComplete() throws IOException {
            try {
                HttpExchange.this.onResponseComplete();
            }
            finally {
                HttpExchange httpExchange = HttpExchange.this;
                synchronized (httpExchange) {
                    HttpExchange.this._onResponseCompleteDone = true;
                    HttpExchange.this._onDone = HttpExchange.this._onRequestCompleteDone;
                    if (HttpExchange.this._onDone) {
                        HttpExchange.this.disassociate();
                    }
                    HttpExchange.this.notifyAll();
                }
            }
        }

        @Override
        public void onResponseContent(Buffer content) throws IOException {
            HttpExchange.this.onResponseContent(content);
        }

        @Override
        public void onResponseHeader(Buffer name, Buffer value) throws IOException {
            HttpExchange.this.onResponseHeader(name, value);
        }

        @Override
        public void onResponseHeaderComplete() throws IOException {
            HttpExchange.this.onResponseHeaderComplete();
        }

        @Override
        public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            HttpExchange.this.onResponseStatus(version, status, reason);
        }

        @Override
        public void onRetry() {
            HttpExchange.this.setRetryStatus(true);
            try {
                HttpExchange.this.onRetry();
            }
            catch (IOException e) {
                Log.debug((Throwable)e);
            }
        }
    }
}

