/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.webdav;

import java.io.IOException;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.log.Log;

public class WebdavSupportedExchange
extends HttpExchange {
    private boolean _webdavSupported = false;
    private boolean _isComplete = false;

    @Override
    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("WebdavSupportedExchange:Header:" + name.toString() + " / " + value.toString()));
        }
        if ("DAV".equals(name.toString()) && (value.toString().indexOf("1") >= 0 || value.toString().indexOf("2") >= 0)) {
            this._webdavSupported = true;
        }
        super.onResponseHeader(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTilCompletion() throws InterruptedException {
        WebdavSupportedExchange webdavSupportedExchange = this;
        synchronized (webdavSupportedExchange) {
            while (!this._isComplete) {
                this.wait();
            }
        }
    }

    @Override
    protected void onResponseComplete() throws IOException {
        this._isComplete = true;
        super.onResponseComplete();
    }

    public boolean isWebdavSupported() {
        return this._webdavSupported;
    }
}

