/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private static final Pattern WWW_AUTHENTICATE_PATTERN = Pattern.compile("([^\\s]+)\\s+realm=\"([^\"]+)\".*", 2);
    private final ResponseNotifier notifier = new ResponseNotifier();
    private final HttpClient client;
    private final int maxContentLength;

    public AuthenticationProtocolHandler(HttpClient client) {
        this(client, 4096);
    }

    public AuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        this.client = client;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.status() == 401;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    private class WWWAuthenticate {
        private final String value;
        private final String type;
        private final String realm;

        public WWWAuthenticate(String value, String type, String realm) {
            this.value = value;
            this.type = type;
            this.realm = realm;
        }
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result) {
            Request request = result.getRequest();
            HttpContentResponse response = new HttpContentResponse(result.getResponse(), this.getContent());
            if (result.isFailed()) {
                Throwable failure = result.getFailure();
                LOG.debug("Authentication challenge failed {}", failure);
                this.forwardFailure(request, response, failure);
                return;
            }
            List<WWWAuthenticate> wwwAuthenticates = this.parseWWWAuthenticate(response);
            if (wwwAuthenticates.isEmpty()) {
                LOG.debug("Authentication challenge without WWW-Authenticate header", new Object[0]);
                this.forwardFailure(request, response, new HttpResponseException("HTTP protocol violation: 401 without WWW-Authenticate header", response));
                return;
            }
            String uri = request.uri();
            Authentication authentication = null;
            WWWAuthenticate wwwAuthenticate = null;
            for (WWWAuthenticate wwwAuthn : wwwAuthenticates) {
                authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(wwwAuthn.type, uri, wwwAuthn.realm);
                if (authentication == null) continue;
                wwwAuthenticate = wwwAuthn;
                break;
            }
            if (authentication == null) {
                LOG.debug("No authentication available for {}", new Object[]{request});
                this.forwardSuccess(request, response);
                return;
            }
            HttpConversation conversation = AuthenticationProtocolHandler.this.client.getConversation(request);
            final Authentication.Result authnResult = authentication.authenticate(request, response, wwwAuthenticate.value, conversation);
            LOG.debug("Authentication result {}", new Object[]{authnResult});
            if (authnResult == null) {
                this.forwardSuccess(request, response);
                return;
            }
            authnResult.apply(request);
            request.send(new Response.Listener.Empty(){

                @Override
                public void onSuccess(Response response) {
                    AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(authnResult);
                }
            });
        }

        private void forwardFailure(Request request, Response response, Throwable failure) {
            HttpConversation conversation = AuthenticationProtocolHandler.this.client.getConversation(request);
            Response.Listener listener = conversation.exchanges().peekFirst().listener();
            AuthenticationProtocolHandler.this.notifier.notifyBegin(listener, response);
            AuthenticationProtocolHandler.this.notifier.notifyHeaders(listener, response);
            if (response instanceof ContentResponse) {
                AuthenticationProtocolHandler.this.notifier.notifyContent(listener, response, ByteBuffer.wrap(((ContentResponse)response).content()));
            }
            AuthenticationProtocolHandler.this.notifier.notifyFailure(listener, response, failure);
            conversation.complete();
            AuthenticationProtocolHandler.this.notifier.notifyComplete(listener, new Result(request, response, failure));
        }

        private void forwardSuccess(Request request, Response response) {
            HttpConversation conversation = AuthenticationProtocolHandler.this.client.getConversation(request);
            Response.Listener listener = conversation.exchanges().peekFirst().listener();
            AuthenticationProtocolHandler.this.notifier.notifyBegin(listener, response);
            AuthenticationProtocolHandler.this.notifier.notifyHeaders(listener, response);
            if (response instanceof ContentResponse) {
                AuthenticationProtocolHandler.this.notifier.notifyContent(listener, response, ByteBuffer.wrap(((ContentResponse)response).content()));
            }
            AuthenticationProtocolHandler.this.notifier.notifySuccess(listener, response);
            conversation.complete();
            AuthenticationProtocolHandler.this.notifier.notifyComplete(listener, new Result(request, response));
        }

        private List<WWWAuthenticate> parseWWWAuthenticate(Response response) {
            ArrayList<WWWAuthenticate> result = new ArrayList<WWWAuthenticate>();
            ArrayList<String> values = Collections.list(response.headers().getValues(HttpHeader.WWW_AUTHENTICATE.asString()));
            for (String value : values) {
                Matcher matcher = WWW_AUTHENTICATE_PATTERN.matcher(value);
                if (!matcher.matches()) continue;
                String type = matcher.group(1);
                String realm = matcher.group(2);
                WWWAuthenticate wwwAuthenticate = new WWWAuthenticate(value, type, realm);
                result.add(wwwAuthenticate);
            }
            return result;
        }
    }
}

