/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.client.AuthenticationProtocolHandler;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.GZIPContentDecoder;
import org.eclipse.jetty.client.HttpAuthenticationStore;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpCookieStore;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.RedirectProtocolHandler;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.CookieStore;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;

public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<String, HttpDestination> destinations = new ConcurrentHashMap<String, HttpDestination>();
    private final ConcurrentMap<Long, HttpConversation> conversations = new ConcurrentHashMap<Long, HttpConversation>();
    private final List<ProtocolHandler> handlers = new CopyOnWriteArrayList<ProtocolHandler>();
    private final List<Request.Listener> requestListeners = new CopyOnWriteArrayList<Request.Listener>();
    private final CookieStore cookieStore = new HttpCookieStore();
    private final AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private final Set<ContentDecoder.Factory> decoderFactories = Collections.newSetFromMap(new ConcurrentHashMap());
    private final SslContextFactory sslContextFactory;
    private volatile Executor executor;
    private volatile ByteBufferPool byteBufferPool;
    private volatile Scheduler scheduler;
    private volatile SelectorManager selectorManager;
    private volatile String agent = "Jetty/" + Jetty.VERSION;
    private volatile boolean followRedirects = true;
    private volatile int maxConnectionsPerAddress = 8;
    private volatile int maxQueueSizePerAddress = 1024;
    private volatile int requestBufferSize = 4096;
    private volatile int responseBufferSize = 4096;
    private volatile int maxRedirects = 8;
    private volatile SocketAddress bindAddress;
    private volatile long idleTimeout;

    public HttpClient() {
        this(null);
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected void doStart() throws Exception {
        if (this.sslContextFactory != null) {
            this.addBean(this.sslContextFactory);
        }
        if (this.executor == null) {
            this.executor = new QueuedThreadPool();
        }
        this.addBean(this.executor);
        if (this.byteBufferPool == null) {
            this.byteBufferPool = new MappedByteBufferPool();
        }
        this.addBean(this.byteBufferPool);
        if (this.scheduler == null) {
            this.scheduler = new TimerScheduler();
        }
        this.addBean(this.scheduler);
        this.selectorManager = this.newSelectorManager();
        this.addBean(this.selectorManager);
        this.handlers.add(new RedirectProtocolHandler(this));
        this.handlers.add(new AuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory());
        super.doStart();
        LOG.info("Started {}", new Object[]{this});
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager();
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping {}", new Object[]{this});
        for (HttpDestination destination : this.destinations.values()) {
            destination.close();
        }
        this.destinations.clear();
        this.conversations.clear();
        this.handlers.clear();
        this.requestListeners.clear();
        this.cookieStore.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        this.decoderFactories.clear();
        super.doStop();
        LOG.info("Stopped {}", new Object[]{this});
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    public Future<ContentResponse> GET(String uri) {
        return this.GET(URI.create(uri));
    }

    public Future<ContentResponse> GET(URI uri) {
        return this.newRequest(uri).send();
    }

    public Request POST(String uri) {
        return this.POST(URI.create(uri));
    }

    public Request POST(URI uri) {
        return this.newRequest(uri).method(HttpMethod.POST);
    }

    public Request newRequest(String host, int port) {
        return this.newRequest(URI.create(this.address("http", host, port)));
    }

    public Request newRequest(String uri) {
        return this.newRequest(URI.create(uri));
    }

    public Request newRequest(URI uri) {
        return new HttpRequest(this, uri);
    }

    protected Request newRequest(long id, String uri) {
        return new HttpRequest(this, id, URI.create(uri));
    }

    private String address(String scheme, String host, int port) {
        return scheme + "://" + host + ":" + port;
    }

    public Destination getDestination(String scheme, String host, int port) {
        return this.provideDestination(scheme, host, port);
    }

    private HttpDestination provideDestination(String scheme, String host, int port) {
        String address = this.address(scheme, host, port);
        HttpDestination destination = (HttpDestination)this.destinations.get(address);
        if (destination == null) {
            destination = new HttpDestination(this, scheme, host, port);
            if (this.isRunning()) {
                HttpDestination existing = this.destinations.putIfAbsent(address, destination);
                if (existing != null) {
                    destination = existing;
                } else {
                    LOG.debug("Created {}", new Object[]{destination});
                }
                if (!this.isRunning()) {
                    this.destinations.remove(address);
                }
            }
        }
        return destination;
    }

    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinations.values());
    }

    protected void send(Request request, Response.Listener listener) {
        String scheme = request.scheme().toLowerCase();
        if (!Arrays.asList("http", "https").contains(scheme)) {
            throw new IllegalArgumentException("Invalid protocol " + scheme);
        }
        String host = request.host().toLowerCase();
        int port = request.port();
        if (port < 0) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        this.provideDestination(scheme, host, port).send(request, listener);
    }

    protected void newConnection(HttpDestination destination, Callback<Connection> callback) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            SocketAddress bindAddress = this.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(destination.host(), destination.port()));
            ConnectionCallback result = new ConnectionCallback(destination, callback);
            this.selectorManager.connect(channel, (Object)result);
        }
        catch (IOException x) {
            if (channel != null) {
                this.close(channel);
            }
            callback.failed(null, (Throwable)x);
        }
    }

    private void close(SocketChannel channel) {
        try {
            channel.close();
        }
        catch (IOException x) {
            LOG.ignore((Throwable)x);
        }
    }

    protected HttpConversation getConversation(Request request) {
        long id = request.id();
        HttpConversation conversation = (HttpConversation)this.conversations.get(id);
        if (conversation == null) {
            conversation = new HttpConversation(this, id);
            HttpConversation existing = this.conversations.putIfAbsent(id, conversation);
            if (existing != null) {
                conversation = existing;
            } else {
                LOG.debug("{} created", new Object[]{conversation});
            }
        }
        return conversation;
    }

    protected void removeConversation(HttpConversation conversation) {
        this.conversations.remove(conversation.id());
        LOG.debug("{} removed", new Object[]{conversation});
    }

    protected Response.Listener lookup(Request request, Response response) {
        for (ProtocolHandler handler : this.handlers) {
            if (!handler.accept(request, response)) continue;
            return handler.getResponseListener();
        }
        return null;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public String getUserAgent() {
        return this.agent;
    }

    public void setUserAgent(String agent) {
        this.agent = agent;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public int getMaxConnectionsPerAddress() {
        return this.maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this.maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    public int getMaxQueueSizePerAddress() {
        return this.maxQueueSizePerAddress;
    }

    public void setMaxQueueSizePerAddress(int maxQueueSizePerAddress) {
        this.maxQueueSizePerAddress = maxQueueSizePerAddress;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        HttpClient.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this.getBeans(), this.destinations.values()});
    }

    private class ConnectionCallback
    extends FutureCallback<Connection> {
        private final HttpDestination destination;
        private final Callback<Connection> callback;

        private ConnectionCallback(HttpDestination destination, Callback<Connection> callback) {
            this.destination = destination;
            this.callback = callback;
        }
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        public ClientSelectorManager() {
            this(1);
        }

        public ClientSelectorManager(int selectors) {
            super(selectors);
        }

        protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key) {
            return new SelectChannelEndPoint(channel, selector, key, HttpClient.this.scheduler, HttpClient.this.getIdleTimeout());
        }

        public org.eclipse.jetty.io.Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            ConnectionCallback callback = (ConnectionCallback)((Object)attachment);
            HttpDestination destination = callback.destination;
            SslContextFactory sslContextFactory = HttpClient.this.getSslContextFactory();
            if ("https".equals(destination.scheme())) {
                if (sslContextFactory == null) {
                    ConnectException failure = new ConnectException("Missing " + SslContextFactory.class.getSimpleName() + " for " + destination.scheme() + " requests");
                    callback.failed(null, failure);
                    throw failure;
                }
                SSLEngine engine = sslContextFactory.newSSLEngine(endPoint.getRemoteAddress());
                engine.setUseClientMode(true);
                SslConnection sslConnection = new SslConnection(HttpClient.this.getByteBufferPool(), HttpClient.this.getExecutor(), endPoint, engine);
                SslConnection.DecryptedEndPoint appEndPoint = sslConnection.getDecryptedEndPoint();
                HttpConnection connection = new HttpConnection(HttpClient.this, (EndPoint)appEndPoint, destination);
                appEndPoint.setConnection((org.eclipse.jetty.io.Connection)connection);
                callback.callback.completed((Object)connection);
                return sslConnection;
            }
            HttpConnection connection = new HttpConnection(HttpClient.this, endPoint, destination);
            callback.callback.completed((Object)connection);
            return connection;
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            ConnectionCallback callback = (ConnectionCallback)((Object)attachment);
            callback.callback.failed(null, ex);
        }

        protected void execute(Runnable task) {
            HttpClient.this.getExecutor().execute(task);
        }
    }
}

