/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpExchange {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final AtomicInteger complete = new AtomicInteger();
    private final HttpConversation conversation;
    private final HttpConnection connection;
    private final Request request;
    private final Response.Listener listener;
    private final HttpResponse response;
    private volatile Throwable requestFailure;
    private volatile Throwable responseFailure;

    public HttpExchange(HttpConversation conversation, HttpConnection connection, Request request, Response.Listener listener) {
        this.conversation = conversation;
        this.connection = connection;
        this.request = request;
        this.listener = listener;
        this.response = new HttpResponse(this, listener);
    }

    public HttpConversation conversation() {
        return this.conversation;
    }

    public Request request() {
        return this.request;
    }

    public Response.Listener listener() {
        return this.listener;
    }

    public HttpResponse response() {
        return this.response;
    }

    public void receive() {
        this.connection.receive();
    }

    public Result requestComplete(Throwable failure) {
        this.requestFailure = failure;
        int requestSuccess = 3;
        int requestFailure = 1;
        return this.complete(failure == null ? requestSuccess : requestFailure);
    }

    public Result responseComplete(Throwable failure) {
        this.responseFailure = failure;
        int responseSuccess = 12;
        int responseFailure = 4;
        return this.complete(failure == null ? responseSuccess : responseFailure);
    }

    private Result complete(int code) {
        int completed;
        int status = this.complete.addAndGet(code);
        if ((status & (completed = 5)) == completed) {
            boolean success = status == 15;
            LOG.debug("{} complete success={}", new Object[]{this, success});
            if (this == this.conversation.last()) {
                this.conversation.complete();
            }
            this.connection.complete(this, success);
            return new Result(this.request, this.requestFailure, this.response, this.responseFailure);
        }
        return null;
    }

    public void abort() {
        LOG.debug("Aborting {}", new Object[]{this.response});
        this.connection.abort(this.response);
    }

    public String toString() {
        String padding = "0000";
        String status = Integer.toBinaryString(this.complete.get());
        return String.format("%s@%x status=%s%s", HttpExchange.class.getSimpleName(), this.hashCode(), padding.substring(status.length()), status);
    }
}

