/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BlockingResponseListener;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Fields;

public class HttpRequest
implements Request {
    private static final AtomicLong ids = new AtomicLong();
    private final HttpFields headers = new HttpFields();
    private final Fields params = new Fields();
    private final HttpClient client;
    private final long id;
    private final String host;
    private final int port;
    private String scheme;
    private String path;
    private HttpMethod method;
    private HttpVersion version;
    private long idleTimeout;
    private Request.Listener listener;
    private ContentProvider content;
    private boolean followRedirects;
    private volatile boolean aborted;

    public HttpRequest(HttpClient client, URI uri) {
        this(client, ids.incrementAndGet(), uri);
    }

    protected HttpRequest(HttpClient client, long id, URI uri) {
        this.client = client;
        this.id = id;
        this.scheme(uri.getScheme());
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path(uri.getPath());
        String query = uri.getRawQuery();
        if (query != null) {
            for (String nameValue : query.split("&")) {
                String[] parts = nameValue.split("=");
                this.param(parts[0], parts.length < 2 ? "" : this.urlDecode(parts[1]));
            }
        }
        this.followRedirects(client.isFollowRedirects());
    }

    private String urlDecode(String value) {
        String charset = "UTF-8";
        try {
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(charset);
        }
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public Request scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public Request method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Request path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String uri() {
        String scheme = this.scheme();
        String result = scheme + "://" + this.host();
        int port = this.port();
        result = result + ("http".equals(scheme) && port != 80 ? ":" + port : "");
        result = result + ("https".equals(scheme) && port != 443 ? ":" + port : "");
        result = result + this.path();
        return result;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public Request version(HttpVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public Request param(String name, String value) {
        this.params.add(name, value);
        return this;
    }

    @Override
    public Fields params() {
        return this.params;
    }

    @Override
    public String agent() {
        return this.headers.get(HttpHeader.USER_AGENT);
    }

    @Override
    public Request agent(String agent) {
        this.headers.put(HttpHeader.USER_AGENT, agent);
        return this;
    }

    @Override
    public Request header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.add(name, value);
        }
        return this;
    }

    @Override
    public HttpFields headers() {
        return this.headers;
    }

    @Override
    public Request.Listener listener() {
        return this.listener;
    }

    @Override
    public Request listener(Request.Listener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public ContentProvider content() {
        return this.content;
    }

    @Override
    public Request content(ContentProvider content) {
        this.content = content;
        return this;
    }

    @Override
    public Request file(Path file) throws IOException {
        return this.file(file, "application/octet-stream");
    }

    @Override
    public Request file(Path file, String contentType) throws IOException {
        if (contentType != null) {
            this.header(HttpHeader.CONTENT_TYPE.asString(), contentType);
        }
        return this.content(new PathContentProvider(file));
    }

    @Override
    public boolean followRedirects() {
        return this.followRedirects;
    }

    @Override
    public Request followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    @Override
    public long idleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Request idleTimeout(long timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    @Override
    public Future<ContentResponse> send() {
        BlockingResponseListener listener = new BlockingResponseListener();
        this.send(listener);
        return listener;
    }

    @Override
    public void send(Response.Listener listener) {
        this.client.send(this, listener);
    }

    @Override
    public void abort() {
        this.aborted = true;
    }

    @Override
    public boolean aborted() {
        return this.aborted;
    }

    public String toString() {
        return String.format("%s[%s %s %s]@%x", HttpRequest.class.getSimpleName(), this.method(), this.path(), this.version(), this.hashCode());
    }
}

