/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpSender {
    private static final Logger LOG = Log.getLogger(HttpSender.class);
    private final HttpGenerator generator = new HttpGenerator();
    private final ResponseNotifier responseNotifier = new ResponseNotifier();
    private final HttpConnection connection;
    private final RequestNotifier requestNotifier;
    private long contentLength;
    private Iterator<ByteBuffer> contentChunks;
    private ByteBuffer header;
    private ByteBuffer chunk;
    private volatile boolean committed;
    private volatile boolean failed;

    public HttpSender(HttpConnection connection) {
        this.connection = connection;
        this.requestNotifier = new RequestNotifier(connection.getHttpClient());
    }

    public void send(HttpExchange exchange) {
        Request request = exchange.request();
        if (request.aborted()) {
            this.fail(new HttpRequestException("Request aborted", request));
        } else {
            LOG.debug("Sending {}", new Object[]{request});
            this.requestNotifier.notifyBegin(request);
            ContentProvider content = request.content();
            this.contentLength = content == null ? -1L : content.length();
            this.contentChunks = content == null ? Collections.emptyIterator() : content.iterator();
            this.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void send() {
        try {
            HttpClient client = this.connection.getHttpClient();
            EndPoint endPoint = this.connection.getEndPoint();
            HttpExchange exchange = this.connection.getExchange();
            ByteBufferPool byteBufferPool = client.getByteBufferPool();
            final Request request = exchange.request();
            HttpGenerator.RequestInfo info = null;
            ByteBuffer content = this.contentChunks.hasNext() ? this.contentChunks.next() : BufferUtil.EMPTY_BUFFER;
            boolean lastContent = !this.contentChunks.hasNext();
            block16: while (true) {
                HttpGenerator.Result result = this.generator.generateRequest(info, this.header, this.chunk, content, lastContent);
                switch (result) {
                    case NEED_INFO: {
                        info = new HttpGenerator.RequestInfo(request.version(), request.headers(), this.contentLength, request.method().asString(), request.path());
                        continue block16;
                    }
                    case NEED_HEADER: {
                        this.header = byteBufferPool.acquire(client.getRequestBufferSize(), false);
                        continue block16;
                    }
                    case NEED_CHUNK: {
                        this.chunk = byteBufferPool.acquire(12, false);
                        continue block16;
                    }
                    case FLUSH: {
                        if (request.aborted()) {
                            this.fail(new HttpRequestException("Request aborted", request));
                            continue block16;
                        }
                        StatefulExecutorCallback callback = new StatefulExecutorCallback(client.getExecutor()){

                            @Override
                            protected void pendingCompleted() {
                                if (!HttpSender.this.committed) {
                                    HttpSender.this.committed(request);
                                }
                                HttpSender.this.send();
                            }

                            @Override
                            protected void failed(Throwable x) {
                                HttpSender.this.fail(x);
                            }
                        };
                        if (this.header == null) {
                            this.header = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.chunk == null) {
                            this.chunk = BufferUtil.EMPTY_BUFFER;
                        }
                        endPoint.write(null, (Callback)callback, new ByteBuffer[]{this.header, this.chunk, content});
                        if (callback.pending()) {
                            return;
                        }
                        if (!callback.completed()) continue block16;
                        if (!this.committed) {
                            this.committed(request);
                        }
                        this.releaseBuffers();
                        content = this.contentChunks.hasNext() ? this.contentChunks.next() : BufferUtil.EMPTY_BUFFER;
                        lastContent = !this.contentChunks.hasNext();
                        continue block16;
                    }
                    case SHUTDOWN_OUT: {
                        endPoint.shutdownOutput();
                        continue block16;
                    }
                    case CONTINUE: {
                        continue block16;
                    }
                    case DONE: {
                        if (!this.generator.isEnd()) return;
                        if (this.failed) return;
                        this.success();
                        return;
                    }
                }
                throw new IllegalStateException("Unknown result " + result);
                continue;
                break;
            }
        }
        catch (Exception x) {
            LOG.debug((Throwable)x);
            this.fail(x);
            return;
        }
        finally {
            this.releaseBuffers();
        }
    }

    protected void committed(Request request) {
        LOG.debug("Committed {}", new Object[]{request});
        this.committed = true;
        this.requestNotifier.notifyHeaders(request);
    }

    protected void success() {
        this.generator.reset();
        this.committed = false;
        HttpExchange exchange = this.connection.getExchange();
        Request request = exchange.request();
        LOG.debug("Sent {}", new Object[]{request});
        Result result = exchange.requestComplete(null);
        this.requestNotifier.notifySuccess(request);
        if (result != null) {
            HttpConversation conversation = exchange.conversation();
            this.responseNotifier.notifyComplete(conversation.listener(), result);
        }
    }

    protected void fail(Throwable failure) {
        BufferUtil.clear((ByteBuffer)this.header);
        BufferUtil.clear((ByteBuffer)this.chunk);
        this.releaseBuffers();
        this.generator.abort();
        this.failed = true;
        HttpExchange exchange = this.connection.getExchange();
        Request request = exchange.request();
        LOG.debug("Failed {} {}", new Object[]{request, failure});
        Result result = exchange.requestComplete(failure);
        if (result == null && !this.committed) {
            result = exchange.responseComplete(null);
        }
        if (result == null) {
            this.connection.getEndPoint().shutdownOutput();
        }
        this.requestNotifier.notifyFailure(request, failure);
        if (result != null) {
            HttpConversation conversation = exchange.conversation();
            this.responseNotifier.notifyComplete(conversation.listener(), result);
        }
    }

    private void releaseBuffers() {
        ByteBufferPool bufferPool = this.connection.getHttpClient().getByteBufferPool();
        if (!BufferUtil.hasContent((ByteBuffer)this.header)) {
            bufferPool.release(this.header);
            this.header = null;
        }
        if (!BufferUtil.hasContent((ByteBuffer)this.chunk)) {
            bufferPool.release(this.chunk);
            this.chunk = null;
        }
    }

    private static abstract class StatefulExecutorCallback
    implements Callback<Void>,
    Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.INCOMPLETE);
        private final Executor executor;

        private StatefulExecutorCallback(Executor executor) {
            this.executor = executor;
        }

        public final void completed(Void context) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.COMPLETE)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(this);
            }
        }

        @Override
        public final void run() {
            this.pendingCompleted();
        }

        protected abstract void pendingCompleted();

        public final void failed(Void context, final Throwable x) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.FAILED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        StatefulExecutorCallback.this.failed(x);
                    }
                });
            } else {
                this.failed(x);
            }
        }

        protected abstract void failed(Throwable var1);

        public boolean pending() {
            return this.state.compareAndSet(State.INCOMPLETE, State.PENDING);
        }

        public boolean completed() {
            return this.state.get() == State.COMPLETE;
        }

        public boolean failed() {
            return this.state.get() == State.FAILED;
        }

        private static enum State {
            INCOMPLETE,
            PENDING,
            COMPLETE,
            FAILED;

        }
    }
}

