/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;

public class RedirectProtocolHandler
extends Response.Listener.Empty
implements ProtocolHandler {
    private static final String ATTRIBUTE = RedirectProtocolHandler.class.getName() + ".redirect";
    private final ResponseNotifier notifier = new ResponseNotifier();
    private final HttpClient client;

    public RedirectProtocolHandler(HttpClient client) {
        this.client = client;
    }

    @Override
    public boolean accept(Request request, Response response) {
        switch (response.status()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return request.followRedirects();
            }
        }
        return false;
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public void onComplete(Result result) {
        if (!result.isFailed()) {
            Request request = result.getRequest();
            Response response = result.getResponse();
            String location = response.headers().get("location");
            int status = response.status();
            switch (status) {
                case 301: {
                    if (request.method() == HttpMethod.GET || request.method() == HttpMethod.HEAD) {
                        this.redirect(result, request.method(), location);
                        break;
                    }
                    this.fail(result, new HttpResponseException("HTTP protocol violation: received 301 for non GET or HEAD request", response));
                    break;
                }
                case 302: 
                case 303: {
                    this.redirect(result, HttpMethod.GET, location);
                    break;
                }
                case 307: {
                    this.redirect(result, request.method(), location);
                    break;
                }
                default: {
                    this.fail(result, new HttpResponseException("Unhandled HTTP status code " + status, response));
                    break;
                }
            }
        } else {
            this.fail(result, result.getFailure());
        }
    }

    private void redirect(Result result, HttpMethod method, String location) {
        Request request = result.getRequest();
        HttpConversation conversation = this.client.getConversation(request);
        Integer redirects = (Integer)conversation.getAttribute(ATTRIBUTE);
        if (redirects == null) {
            redirects = 0;
        }
        if (redirects < this.client.getMaxRedirects()) {
            redirects = redirects + 1;
            conversation.setAttribute(ATTRIBUTE, redirects);
            Request redirect = this.client.newRequest(request.id(), location);
            redirect.method(method);
            redirect.version(request.version());
            for (HttpFields.Field header : request.headers()) {
                redirect.header(header.getName(), header.getValue());
            }
            redirect.content(request.content());
            redirect.send(new Response.Listener.Empty());
        } else {
            this.fail(result, new HttpResponseException("Max redirects exceeded " + redirects, result.getResponse()));
        }
    }

    private void fail(Result result, Throwable failure) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        HttpConversation conversation = this.client.getConversation(request);
        Response.Listener listener = conversation.exchanges().peekFirst().listener();
        this.notifier.notifyFailure(listener, response, failure);
        this.notifier.notifyComplete(listener, new Result(request, response, failure));
    }
}

