/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);
    private final HttpClient client;

    public RequestNotifier(HttpClient client) {
        this.client = client;
    }

    public void notifyQueued(Request request) {
        this.notifyQueued(request.listener(), request);
        for (Request.Listener listener : this.client.getRequestListeners()) {
            this.notifyQueued(listener, request);
        }
    }

    private void notifyQueued(Request.Listener listener, Request request) {
        try {
            if (listener != null) {
                listener.onQueued(request);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyBegin(Request request) {
        this.notifyBegin(request.listener(), request);
        for (Request.Listener listener : this.client.getRequestListeners()) {
            this.notifyBegin(listener, request);
        }
    }

    private void notifyBegin(Request.Listener listener, Request request) {
        try {
            if (listener != null) {
                listener.onBegin(request);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyHeaders(Request request) {
        this.notifyHeaders(request.listener(), request);
        for (Request.Listener listener : this.client.getRequestListeners()) {
            this.notifyHeaders(listener, request);
        }
    }

    private void notifyHeaders(Request.Listener listener, Request request) {
        try {
            if (listener != null) {
                listener.onHeaders(request);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifySuccess(Request request) {
        this.notifySuccess(request.listener(), request);
        for (Request.Listener listener : this.client.getRequestListeners()) {
            this.notifySuccess(listener, request);
        }
    }

    private void notifySuccess(Request.Listener listener, Request request) {
        try {
            if (listener != null) {
                listener.onSuccess(request);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyFailure(Request request, Throwable failure) {
        this.notifyFailure(request.listener(), request, failure);
        for (Request.Listener listener : this.client.getRequestListeners()) {
            this.notifyFailure(listener, request, failure);
        }
    }

    private void notifyFailure(Request.Listener listener, Request request, Throwable failure) {
        try {
            if (listener != null) {
                listener.onFailure(request, failure);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }
}

