/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Future;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Fields;

public interface Request {
    public long id();

    public String scheme();

    public Request scheme(String var1);

    public String host();

    public int port();

    public HttpMethod method();

    public Request method(HttpMethod var1);

    public String path();

    public Request path(String var1);

    public String uri();

    public HttpVersion version();

    public Request version(HttpVersion var1);

    public Fields params();

    public Request param(String var1, String var2);

    public HttpFields headers();

    public Request header(String var1, String var2);

    public ContentProvider content();

    public Request content(ContentProvider var1);

    public Request file(Path var1) throws IOException;

    public Request file(Path var1, String var2) throws IOException;

    public String agent();

    public Request agent(String var1);

    public long idleTimeout();

    public Request idleTimeout(long var1);

    public boolean followRedirects();

    public Request followRedirects(boolean var1);

    public Listener listener();

    public Request listener(Listener var1);

    public Future<ContentResponse> send();

    public void send(Response.Listener var1);

    public void abort();

    public boolean aborted();

    public static interface Listener {
        public void onQueued(Request var1);

        public void onBegin(Request var1);

        public void onHeaders(Request var1);

        public void onSuccess(Request var1);

        public void onFailure(Request var1, Throwable var2);

        public static class Empty
        implements Listener {
            @Override
            public void onQueued(Request request) {
            }

            @Override
            public void onBegin(Request request) {
            }

            @Override
            public void onHeaders(Request request) {
            }

            @Override
            public void onSuccess(Request request) {
            }

            @Override
            public void onFailure(Request request, Throwable failure) {
            }
        }
    }
}

