/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public interface Response {
    public Listener listener();

    public HttpVersion version();

    public int status();

    public String reason();

    public HttpFields headers();

    public void abort();

    public static interface Listener {
        public void onBegin(Response var1);

        public void onHeaders(Response var1);

        public void onContent(Response var1, ByteBuffer var2);

        public void onSuccess(Response var1);

        public void onFailure(Response var1, Throwable var2);

        public void onComplete(Result var1);

        public static class Empty
        implements Listener {
            @Override
            public void onBegin(Response response) {
            }

            @Override
            public void onHeaders(Response response) {
            }

            @Override
            public void onContent(Response response, ByteBuffer content) {
            }

            @Override
            public void onSuccess(Response response) {
            }

            @Override
            public void onFailure(Response response, Throwable failure) {
            }

            @Override
            public void onComplete(Result result) {
            }
        }
    }
}

