/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;

public class BlockingResponseListener
extends BufferingResponseListener
implements Future<ContentResponse> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private ContentResponse response;
    private Throwable failure;
    private volatile boolean cancelled;

    @Override
    public void onBegin(Response response) {
        super.onBegin(response);
        if (this.cancelled) {
            response.abort();
        }
    }

    @Override
    public void onHeaders(Response response) {
        super.onHeaders(response);
        if (this.cancelled) {
            response.abort();
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        super.onContent(response, content);
        if (this.cancelled) {
            response.abort();
        }
    }

    @Override
    public void onComplete(Result result) {
        super.onComplete(result);
        this.response = new HttpContentResponse(result.getResponse(), this.getContent());
        this.failure = result.getFailure();
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L || this.isCancelled();
    }

    @Override
    public ContentResponse get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.result();
    }

    @Override
    public ContentResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.latch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        return this.result();
    }

    private ContentResponse result() throws ExecutionException {
        if (this.isCancelled()) {
            throw (CancellationException)new CancellationException().initCause(this.failure);
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.response;
    }
}

