/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.jetty.client.api.Response;

public class BufferingResponseListener
extends Response.Listener.Empty {
    private final int maxLength;
    private volatile byte[] buffer = new byte[0];

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        long newLength = this.buffer.length + content.remaining();
        if (newLength > (long)this.maxLength) {
            throw new IllegalStateException("Buffering capacity exceeded");
        }
        byte[] newBuffer = new byte[(int)newLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        content.get(newBuffer, this.buffer.length, content.remaining());
        this.buffer = newBuffer;
    }

    public byte[] getContent() {
        return this.buffer;
    }

    public String getContent(String encoding) {
        try {
            return new String(this.getContent(), encoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(encoding);
        }
    }
}

