/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private static final Pattern WWW_AUTHENTICATE_PATTERN = Pattern.compile("([^\\s]+)\\s+realm=\"([^\"]+)\".*", 2);
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;

    public AuthenticationProtocolHandler(HttpClient client) {
        this(client, 4096);
    }

    public AuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        this.client = client;
        this.maxContentLength = maxContentLength;
        this.notifier = new ResponseNotifier(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.status() == 401;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    private class WWWAuthenticate {
        private final String value;
        private final String type;
        private final String realm;

        public WWWAuthenticate(String value, String type, String realm) {
            this.value = value;
            this.type = type;
            this.realm = realm;
        }
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        @Override
        public void onComplete(Result result) {
            Request request = result.getRequest();
            HttpConversation conversation = AuthenticationProtocolHandler.this.client.getConversation(request.conversation());
            Response.Listener listener = conversation.exchanges().peekFirst().listener();
            HttpContentResponse response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getEncoding());
            if (result.isFailed()) {
                Throwable failure = result.getFailure();
                LOG.debug("Authentication challenge failed {}", failure);
                AuthenticationProtocolHandler.this.notifier.forwardFailureComplete(listener, request, result.getRequestFailure(), response, result.getResponseFailure());
                return;
            }
            List<WWWAuthenticate> wwwAuthenticates = this.parseWWWAuthenticate(response);
            if (wwwAuthenticates.isEmpty()) {
                LOG.debug("Authentication challenge without WWW-Authenticate header", new Object[0]);
                AuthenticationProtocolHandler.this.notifier.forwardFailureComplete(listener, request, null, response, new HttpResponseException("HTTP protocol violation: 401 without WWW-Authenticate header", response));
                return;
            }
            String uri = request.uri();
            Authentication authentication = null;
            WWWAuthenticate wwwAuthenticate = null;
            for (WWWAuthenticate wwwAuthn : wwwAuthenticates) {
                authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(wwwAuthn.type, uri, wwwAuthn.realm);
                if (authentication == null) continue;
                wwwAuthenticate = wwwAuthn;
                break;
            }
            if (authentication == null) {
                LOG.debug("No authentication available for {}", new Object[]{request});
                AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(listener, request, response);
                return;
            }
            final Authentication.Result authnResult = authentication.authenticate(request, response, wwwAuthenticate.value, conversation);
            LOG.debug("Authentication result {}", new Object[]{authnResult});
            if (authnResult == null) {
                AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(listener, request, response);
                return;
            }
            authnResult.apply(request);
            request.send(new Response.Listener.Empty(){

                @Override
                public void onSuccess(Response response) {
                    AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(authnResult);
                }
            });
        }

        private List<WWWAuthenticate> parseWWWAuthenticate(Response response) {
            ArrayList<WWWAuthenticate> result = new ArrayList<WWWAuthenticate>();
            ArrayList<String> values = Collections.list(response.headers().getValues(HttpHeader.WWW_AUTHENTICATE.asString()));
            for (String value : values) {
                Matcher matcher = WWW_AUTHENTICATE_PATTERN.matcher(value);
                if (!matcher.matches()) continue;
                String type = matcher.group(1);
                String realm = matcher.group(2);
                WWWAuthenticate wwwAuthenticate = new WWWAuthenticate(value, type, realm);
                result.add(wwwAuthenticate);
            }
            return result;
        }
    }
}

