/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class ContinueProtocolHandler
implements ProtocolHandler {
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    public ContinueProtocolHandler(HttpClient client) {
        this.client = client;
        this.notifier = new ResponseNotifier(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        boolean expect100 = request.headers().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        boolean handled100 = this.client.getConversation(request.conversation()).getAttribute(ATTRIBUTE) != null;
        return expect100 && !handled100;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    private class ContinueListener
    extends BufferingResponseListener {
        private ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            HttpConversation conversation = ContinueProtocolHandler.this.client.getConversation(response.conversation());
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            HttpExchange exchange = conversation.exchanges().peekLast();
            assert (exchange.response() == response);
            Response.Listener listener = exchange.listener();
            switch (response.status()) {
                case 100: {
                    exchange.resetResponse(true);
                    conversation.listener(listener);
                    exchange.proceed(true);
                    break;
                }
                default: {
                    HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getEncoding());
                    ContinueProtocolHandler.this.notifier.forwardSuccess(listener, contentResponse);
                    conversation.listener(listener);
                    exchange.proceed(false);
                    break;
                }
            }
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpConversation conversation = ContinueProtocolHandler.this.client.getConversation(response.conversation());
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            HttpExchange exchange = conversation.exchanges().peekLast();
            assert (exchange.response() == response);
            Response.Listener listener = exchange.listener();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getEncoding());
            ContinueProtocolHandler.this.notifier.forwardFailureComplete(listener, exchange.request(), exchange.requestFailure(), contentResponse, failure);
        }
    }
}

