/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;

public class HttpAuthenticationStore
implements AuthenticationStore {
    private final List<Authentication> authentications = new CopyOnWriteArrayList<Authentication>();
    private final Map<String, Authentication.Result> results = new ConcurrentHashMap<String, Authentication.Result>();

    @Override
    public void addAuthentication(Authentication authentication) {
        this.authentications.add(authentication);
    }

    @Override
    public void removeAuthentication(Authentication authentication) {
        this.authentications.remove(authentication);
    }

    @Override
    public void clearAuthentications() {
        this.authentications.clear();
    }

    @Override
    public Authentication findAuthentication(String type, String uri, String realm) {
        for (Authentication authentication : this.authentications) {
            if (!authentication.matches(type, uri, realm)) continue;
            return authentication;
        }
        return null;
    }

    @Override
    public void addAuthenticationResult(Authentication.Result result) {
        this.results.put(result.getURI(), result);
    }

    @Override
    public void removeAuthenticationResult(Authentication.Result result) {
        this.results.remove(result.getURI());
    }

    @Override
    public void clearAuthenticationResults() {
        this.results.clear();
    }

    @Override
    public Authentication.Result findAuthenticationResult(String uri) {
        for (Map.Entry<String, Authentication.Result> entry : this.results.entrySet()) {
            if (!uri.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

