/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnection
extends AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final AtomicReference<HttpExchange> exchange = new AtomicReference();
    private final HttpClient client;
    private final HttpDestination destination;
    private final HttpSender sender;
    private final HttpReceiver receiver;
    private long idleTimeout;

    public HttpConnection(HttpClient client, EndPoint endPoint, HttpDestination destination) {
        super(endPoint, client.getExecutor(), client.isDispatchIO());
        this.client = client;
        this.destination = destination;
        this.sender = new HttpSender(this);
        this.receiver = new HttpReceiver(this);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public HttpDestination getDestination() {
        return this.destination;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    protected boolean onReadTimeout() {
        LOG.debug("{} idle timeout", new Object[]{this});
        HttpExchange exchange = this.getExchange();
        if (exchange != null) {
            this.idleTimeout();
        } else {
            this.destination.remove(this);
        }
        return true;
    }

    protected void idleTimeout() {
        this.receiver.idleTimeout();
    }

    @Override
    public void send(Request request, Response.Listener listener) {
        this.normalizeRequest(request);
        EndPoint endPoint = this.getEndPoint();
        this.idleTimeout = endPoint.getIdleTimeout();
        endPoint.setIdleTimeout(request.idleTimeout());
        HttpConversation conversation = this.client.getConversation(request.conversation());
        HttpExchange exchange = new HttpExchange(conversation, this, request, listener);
        this.setExchange(exchange);
        conversation.exchanges().offer(exchange);
        conversation.listener(listener);
        this.sender.send(exchange);
    }

    private void normalizeRequest(Request request) {
        Set<ContentDecoder.Factory> decoderFactories;
        Authentication.Result authnResult;
        Fields fields;
        if (request.method() == null) {
            request.method(HttpMethod.GET);
        }
        if (request.version() == null) {
            request.version(HttpVersion.HTTP_1_1);
        }
        if (request.agent() == null) {
            request.agent(this.client.getUserAgent());
        }
        if (request.idleTimeout() <= 0L) {
            request.idleTimeout(this.client.getIdleTimeout());
        }
        HttpMethod method = request.method();
        HttpVersion version = request.version();
        HttpFields headers = request.headers();
        ContentProvider content = request.content();
        String path = request.path();
        if (path.matches("\\s*")) {
            path = "/";
            request.path(path);
        }
        if (!(fields = request.params()).isEmpty()) {
            StringBuilder params = new StringBuilder();
            Iterator fieldIterator = fields.iterator();
            while (fieldIterator.hasNext()) {
                Fields.Field field = (Fields.Field)fieldIterator.next();
                String[] values = field.values();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        params.append("&");
                    }
                    params.append(field.name()).append("=");
                    params.append(this.urlEncode(values[i]));
                }
                if (!fieldIterator.hasNext()) continue;
                params.append("&");
            }
            if (method == HttpMethod.POST && request.content() != null) {
                method = HttpMethod.GET;
            }
            switch (method) {
                case GET: {
                    path = path + "?";
                    path = path + params.toString();
                    request.path(path);
                    break;
                }
                case POST: {
                    request.header(HttpHeader.CONTENT_TYPE.asString(), MimeTypes.Type.FORM_ENCODED.asString());
                    request.content(new StringContentProvider(params.toString()));
                }
            }
        }
        if (version.getVersion() > 10 && !headers.containsKey(HttpHeader.HOST.asString())) {
            String value = request.host();
            int port = request.port();
            if (port > 0) {
                value = value + ":" + port;
            }
            headers.put(HttpHeader.HOST, value);
        }
        if (content != null) {
            long contentLength = content.length();
            if (contentLength >= 0L) {
                if (!headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                    headers.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
                }
            } else if (!headers.containsKey(HttpHeader.TRANSFER_ENCODING.asString())) {
                headers.put(HttpHeader.TRANSFER_ENCODING, "chunked");
            }
        }
        List<HttpCookie> cookies = this.client.getCookieStore().findCookies(this.getDestination(), request.path());
        StringBuilder cookieString = null;
        for (int i = 0; i < cookies.size(); ++i) {
            if (cookieString == null) {
                cookieString = new StringBuilder();
            }
            if (i > 0) {
                cookieString.append("; ");
            }
            HttpCookie cookie = cookies.get(i);
            cookieString.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        if (cookieString != null) {
            request.header(HttpHeader.COOKIE.asString(), cookieString.toString());
        }
        if ((authnResult = this.client.getAuthenticationStore().findAuthenticationResult(request.uri())) != null) {
            authnResult.apply(request);
        }
        if (!headers.containsKey(HttpHeader.ACCEPT_ENCODING.asString()) && !(decoderFactories = this.client.getContentDecoderFactories()).isEmpty()) {
            StringBuilder value = new StringBuilder();
            Iterator<ContentDecoder.Factory> iterator = decoderFactories.iterator();
            while (iterator.hasNext()) {
                ContentDecoder.Factory decoderFactory = iterator.next();
                value.append(decoderFactory.getEncoding());
                if (!iterator.hasNext()) continue;
                value.append(",");
            }
            headers.put(HttpHeader.ACCEPT_ENCODING, value.toString());
        }
    }

    private String urlEncode(String value) {
        String encoding = "UTF-8";
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(encoding);
        }
    }

    public HttpExchange getExchange() {
        return this.exchange.get();
    }

    protected void setExchange(HttpExchange exchange) {
        if (!this.exchange.compareAndSet(null, exchange)) {
            throw new UnsupportedOperationException("Pipelined requests not supported");
        }
        LOG.debug("{} associated to {}", new Object[]{exchange, this});
    }

    public void onFillable() {
        HttpExchange exchange = this.getExchange();
        if (exchange != null) {
            exchange.receive();
        } else {
            this.close();
        }
    }

    protected void receive() {
        this.receiver.receive();
    }

    public void complete(HttpExchange exchange, boolean success) {
        HttpExchange existing = this.exchange.getAndSet(null);
        if (existing == exchange) {
            this.getEndPoint().setIdleTimeout(this.idleTimeout);
            LOG.debug("{} disassociated from {}", new Object[]{exchange, this});
            if (success) {
                HttpFields responseHeaders = exchange.response().headers();
                Enumeration values = responseHeaders.getValues(HttpHeader.CONNECTION.asString(), ",");
                if (values != null) {
                    while (values.hasMoreElements()) {
                        if (!"close".equalsIgnoreCase((String)values.nextElement())) continue;
                        this.close();
                        return;
                    }
                }
                this.destination.release(this);
            } else {
                this.close();
            }
        } else if (existing != null) {
            throw new IllegalStateException();
        }
    }

    public void abort(HttpResponse response) {
        this.receiver.fail(new HttpResponseException("Response aborted", response));
    }

    public void proceed(boolean proceed) {
        this.sender.proceed(proceed);
    }

    @Override
    public void close() {
        this.destination.remove(this);
        this.getEndPoint().shutdownOutput();
        LOG.debug("{} oshut", new Object[]{this});
        this.getEndPoint().close();
        LOG.debug("{} closed", new Object[]{this});
    }

    public String toString() {
        return String.format("%s@%x(l:%s <-> r:%s)", HttpConnection.class.getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress());
    }
}

