/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public class HttpContentResponse
implements ContentResponse {
    private final Response response;
    private final byte[] content;
    private final String encoding;

    public HttpContentResponse(Response response, byte[] content, String encoding) {
        this.response = response;
        this.content = content;
        this.encoding = encoding;
    }

    @Override
    public long conversation() {
        return this.response.conversation();
    }

    @Override
    public Response.Listener listener() {
        return this.response.listener();
    }

    @Override
    public HttpVersion version() {
        return this.response.version();
    }

    @Override
    public int status() {
        return this.response.status();
    }

    @Override
    public String reason() {
        return this.response.reason();
    }

    @Override
    public HttpFields headers() {
        return this.response.headers();
    }

    @Override
    public void abort() {
        this.response.abort();
    }

    @Override
    public byte[] content() {
        return this.content;
    }

    @Override
    public String contentAsString() {
        String encoding = this.encoding;
        try {
            return new String(this.content(), encoding == null ? "UTF-8" : encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(encoding);
        }
    }

    public String toString() {
        return String.format("%s[%s %d %s - %d bytes]", HttpContentResponse.class.getSimpleName(), this.version(), this.status(), this.reason(), this.content().length);
    }
}

