/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpCookieParser;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.CookieStore;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpReceiver
implements HttpParser.ResponseHandler<ByteBuffer> {
    private static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final HttpParser parser = new HttpParser((HttpParser.ResponseHandler)this);
    private final HttpConnection connection;
    private final ResponseNotifier notifier;
    private ContentDecoder decoder;
    private State state = State.IDLE;

    public HttpReceiver(HttpConnection connection) {
        this.connection = connection;
        this.notifier = new ResponseNotifier(connection.getHttpClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive() {
        EndPoint endPoint = this.connection.getEndPoint();
        HttpClient client = this.connection.getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        ByteBuffer buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
        try {
            int read;
            block7: while (true) {
                read = endPoint.fill(buffer);
                LOG.debug("Read {} bytes from {}", new Object[]{read, this.connection});
                if (read <= 0) break;
                while (true) {
                    if (!buffer.hasRemaining()) continue block7;
                    this.parser.parseNext(buffer);
                }
                break;
            }
            if (read == 0) {
                this.connection.fillInterested();
            } else {
                this.parser.shutdownInput();
                if (this.state == State.IDLE || this.state == State.RECEIVE) {
                    this.fail(new EOFException());
                }
            }
        }
        catch (EofException x) {
            LOG.ignore((Throwable)x);
            this.fail(x);
        }
        catch (Exception x) {
            LOG.debug((Throwable)x);
            this.fail(x);
        }
        finally {
            bufferPool.release(buffer);
        }
    }

    public boolean startResponse(HttpVersion version, int status, String reason) {
        Response.Listener handlerListener;
        this.state = State.RECEIVE;
        HttpExchange exchange = this.connection.getExchange();
        HttpConversation conversation = exchange.conversation();
        HttpResponse response = exchange.response();
        response.version(version).status(status).reason(reason);
        Response.Listener currentListener = exchange.listener();
        Response.Listener initialListener = conversation.exchanges().peekFirst().listener();
        HttpClient client = this.connection.getHttpClient();
        ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.request(), response);
        Response.Listener listener = handlerListener = protocolHandler == null ? null : protocolHandler.getResponseListener();
        if (handlerListener == null) {
            conversation.last(exchange);
            if (currentListener == initialListener) {
                conversation.listener(initialListener);
            } else {
                conversation.listener(new DoubleResponseListener(currentListener, initialListener));
            }
        } else {
            LOG.debug("Found protocol handler {}", new Object[]{protocolHandler});
            if (currentListener == initialListener) {
                conversation.listener(handlerListener);
            } else {
                conversation.listener(new DoubleResponseListener(currentListener, handlerListener));
            }
        }
        LOG.debug("Receiving {}", new Object[]{response});
        this.notifier.notifyBegin(conversation.listener(), response);
        return false;
    }

    public boolean parsedHeader(HttpHeader header, String name, String value) {
        HttpExchange exchange = this.connection.getExchange();
        exchange.response().headers().add(name, value);
        switch (name.toLowerCase()) {
            case "set-cookie": 
            case "set-cookie2": {
                CookieStore cookieStore = this.connection.getHttpClient().getCookieStore();
                HttpDestination destination = this.connection.getDestination();
                List<HttpCookie> cookies = HttpCookieParser.parseCookies(value);
                for (HttpCookie cookie : cookies) {
                    cookieStore.addCookie(destination, cookie);
                }
                break;
            }
        }
        return false;
    }

    public boolean headerComplete() {
        HttpExchange exchange = this.connection.getExchange();
        HttpConversation conversation = exchange.conversation();
        HttpResponse response = exchange.response();
        LOG.debug("Headers {}", new Object[]{response});
        this.notifier.notifyHeaders(conversation.listener(), response);
        Enumeration contentEncodings = response.headers().getValues(HttpHeader.CONTENT_ENCODING.asString(), ",");
        if (contentEncodings != null) {
            block0: for (ContentDecoder.Factory factory : this.connection.getHttpClient().getContentDecoderFactories()) {
                while (contentEncodings.hasMoreElements()) {
                    if (!factory.getEncoding().equalsIgnoreCase((String)contentEncodings.nextElement())) continue;
                    this.decoder = factory.newContentDecoder();
                    continue block0;
                }
            }
        }
        return false;
    }

    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange = this.connection.getExchange();
        HttpConversation conversation = exchange.conversation();
        HttpResponse response = exchange.response();
        LOG.debug("Content {}: {} bytes", new Object[]{response, buffer.remaining()});
        ContentDecoder decoder = this.decoder;
        if (decoder != null) {
            buffer = decoder.decode(buffer);
            LOG.debug("{} {}: {} bytes", new Object[]{decoder, response, buffer.remaining()});
        }
        this.notifier.notifyContent(conversation.listener(), response, buffer);
        return false;
    }

    public boolean messageComplete(long contentLength) {
        HttpExchange exchange = this.connection.getExchange();
        if (exchange != null && this.state == State.RECEIVE) {
            this.success();
        }
        return true;
    }

    protected void success() {
        this.parser.reset();
        this.state = State.SUCCESS;
        HttpExchange exchange = this.connection.getExchange();
        HttpResponse response = exchange.response();
        LOG.debug("Received {}", new Object[]{response});
        Result result = exchange.responseComplete(null);
        HttpConversation conversation = exchange.conversation();
        this.notifier.notifySuccess(conversation.listener(), response);
        if (result != null) {
            this.notifier.notifyComplete(conversation.listener(), result);
            this.reset();
        }
    }

    protected void fail(Throwable failure) {
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return;
        }
        this.parser.close();
        this.state = State.FAILURE;
        HttpResponse response = exchange.response();
        LOG.debug("Failed {} {}", new Object[]{response, failure});
        Result result = exchange.responseComplete(failure);
        HttpConversation conversation = exchange.conversation();
        this.notifier.notifyFailure(conversation.listener(), response, failure);
        if (result != null) {
            this.notifier.notifyComplete(conversation.listener(), result);
            this.reset();
        }
    }

    public boolean earlyEOF() {
        this.fail(new EOFException());
        return false;
    }

    public void badMessage(int status, String reason) {
        HttpExchange exchange = this.connection.getExchange();
        HttpResponse response = exchange.response();
        response.status(status).reason(reason);
        this.fail(new HttpResponseException("HTTP protocol violation: bad response", response));
    }

    public void idleTimeout() {
        this.fail(new TimeoutException());
    }

    private void reset() {
        this.decoder = null;
        this.state = State.IDLE;
    }

    private static enum State {
        IDLE,
        RECEIVE,
        SUCCESS,
        FAILURE;

    }

    private class DoubleResponseListener
    implements Response.Listener {
        private final Response.Listener listener1;
        private final Response.Listener listener2;

        private DoubleResponseListener(Response.Listener listener1, Response.Listener listener2) {
            this.listener1 = listener1;
            this.listener2 = listener2;
        }

        @Override
        public void onBegin(Response response) {
            HttpReceiver.this.notifier.notifyBegin(this.listener1, response);
            HttpReceiver.this.notifier.notifyBegin(this.listener2, response);
        }

        @Override
        public void onHeaders(Response response) {
            HttpReceiver.this.notifier.notifyHeaders(this.listener1, response);
            HttpReceiver.this.notifier.notifyHeaders(this.listener2, response);
        }

        @Override
        public void onContent(Response response, ByteBuffer content) {
            HttpReceiver.this.notifier.notifyContent(this.listener1, response, content);
            HttpReceiver.this.notifier.notifyContent(this.listener2, response, content);
        }

        @Override
        public void onSuccess(Response response) {
            HttpReceiver.this.notifier.notifySuccess(this.listener1, response);
            HttpReceiver.this.notifier.notifySuccess(this.listener2, response);
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpReceiver.this.notifier.notifyFailure(this.listener1, response, failure);
            HttpReceiver.this.notifier.notifyFailure(this.listener2, response, failure);
        }

        @Override
        public void onComplete(Result result) {
            HttpReceiver.this.notifier.notifyComplete(this.listener1, result);
            HttpReceiver.this.notifier.notifyComplete(this.listener2, result);
        }
    }
}

