/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public class HttpResponse
implements Response {
    private final HttpFields headers = new HttpFields();
    private final HttpExchange exchange;
    private final Response.Listener listener;
    private HttpVersion version;
    private int status;
    private String reason;

    public HttpResponse(HttpExchange exchange, Response.Listener listener) {
        this.exchange = exchange;
        this.listener = listener;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public HttpResponse version(HttpVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public int status() {
        return this.status;
    }

    public HttpResponse status(int status) {
        this.status = status;
        return this;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public HttpResponse reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public HttpFields headers() {
        return this.headers;
    }

    @Override
    public long conversation() {
        return this.exchange.request().conversation();
    }

    @Override
    public Response.Listener listener() {
        return this.listener;
    }

    @Override
    public void abort() {
        this.exchange.abort();
    }

    public String toString() {
        return String.format("%s[%s %d %s]", HttpResponse.class.getSimpleName(), this.version(), this.status(), this.reason());
    }
}

