/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpSender {
    private static final Logger LOG = Log.getLogger(HttpSender.class);
    private static final String EXPECT_100_ATTRIBUTE = HttpSender.class.getName() + ".expect100";
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpConnection connection;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private Iterator<ByteBuffer> contentIterator;
    private ContentInfo expectedContent;
    private boolean committed;
    private boolean failed;

    public HttpSender(HttpConnection connection) {
        this.connection = connection;
        this.requestNotifier = new RequestNotifier(connection.getHttpClient());
        this.responseNotifier = new ResponseNotifier(connection.getHttpClient());
    }

    public void send(HttpExchange exchange) {
        Request request = exchange.request();
        if (request.aborted()) {
            this.fail(new HttpRequestException("Request aborted", request));
        } else {
            LOG.debug("Sending {}", new Object[]{request});
            this.requestNotifier.notifyBegin(request);
            ContentProvider content = request.content();
            this.contentIterator = content == null ? Collections.emptyIterator() : content.iterator();
            this.send();
        }
    }

    public void proceed(boolean proceed) {
        ContentInfo contentInfo = this.expectedContent;
        if (contentInfo != null) {
            contentInfo.await();
            if (proceed) {
                this.send();
            } else {
                this.fail(new HttpRequestException("Expectation failed", this.connection.getExchange().request()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void send() {
        HttpClient client = this.connection.getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        ByteBuffer header = null;
        ByteBuffer chunk = null;
        try {
            ContentInfo contentInfo;
            EndPoint endPoint = this.connection.getEndPoint();
            HttpExchange exchange = this.connection.getExchange();
            final Request request = exchange.request();
            HttpConversation conversation = client.getConversation(request.conversation());
            HttpGenerator.RequestInfo requestInfo = null;
            boolean expect100 = request.headers().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            if (expect100 &= conversation.getAttribute(EXPECT_100_ATTRIBUTE) == null) {
                conversation.setAttribute(EXPECT_100_ATTRIBUTE, Boolean.TRUE);
            }
            if ((contentInfo = this.expectedContent) == null) {
                contentInfo = new ContentInfo(this.contentIterator);
            } else {
                expect100 = false;
            }
            this.expectedContent = null;
            block17: while (true) {
                HttpGenerator.Result result = this.generator.generateRequest(requestInfo, header, chunk, contentInfo.content, contentInfo.lastContent);
                switch (result) {
                    case NEED_INFO: {
                        ContentProvider content = request.content();
                        long contentLength = content == null ? -1L : content.length();
                        requestInfo = new HttpGenerator.RequestInfo(request.version(), request.headers(), contentLength, request.method().asString(), request.path());
                        continue block17;
                    }
                    case NEED_HEADER: {
                        header = bufferPool.acquire(client.getRequestBufferSize(), false);
                        continue block17;
                    }
                    case NEED_CHUNK: {
                        chunk = bufferPool.acquire(12, false);
                        continue block17;
                    }
                    case FLUSH: {
                        if (request.aborted()) {
                            this.fail(new HttpRequestException("Request aborted", request));
                            continue block17;
                        }
                        StatefulExecutorCallback callback = new StatefulExecutorCallback(client.getExecutor()){

                            @Override
                            protected void pendingCompleted() {
                                LOG.debug("Write completed for {}", new Object[]{request});
                                if (!HttpSender.this.committed) {
                                    HttpSender.this.committed(request);
                                }
                                if (HttpSender.this.expectedContent == null) {
                                    HttpSender.this.send();
                                } else {
                                    LOG.debug("Expecting 100 Continue for {}", new Object[]{request});
                                    HttpSender.this.expectedContent.ready();
                                }
                            }

                            @Override
                            protected void failed(Throwable x) {
                                HttpSender.this.fail(x);
                            }
                        };
                        if (expect100) {
                            this.expectedContent = contentInfo;
                        }
                        this.write(callback, header, chunk, expect100 ? null : contentInfo.content);
                        if (callback.pending()) {
                            LOG.debug("Write pending for {}", new Object[]{request});
                            this.releaseBuffers(bufferPool, header, chunk);
                            return;
                        }
                        if (!callback.completed()) continue block17;
                        if (!this.committed) {
                            this.committed(request);
                        }
                        if (expect100) {
                            LOG.debug("Expecting 100 Continue for {}", new Object[]{request});
                            this.expectedContent.ready();
                            this.releaseBuffers(bufferPool, header, chunk);
                            return;
                        }
                        contentInfo = new ContentInfo(this.contentIterator);
                        continue block17;
                    }
                    case SHUTDOWN_OUT: {
                        endPoint.shutdownOutput();
                        continue block17;
                    }
                    case CONTINUE: {
                        continue block17;
                    }
                    case DONE: {
                        if (this.generator.isEnd() && !this.failed) {
                            this.success();
                        }
                        this.releaseBuffers(bufferPool, header, chunk);
                        return;
                    }
                }
                throw new IllegalStateException("Unknown result " + result);
                continue;
                break;
            }
            catch (Exception x) {
                LOG.debug((Throwable)x);
                this.fail(x);
                return;
            }
        }
        finally {
            this.releaseBuffers(bufferPool, header, chunk);
        }
    }

    private void write(Callback<Void> callback, ByteBuffer header, ByteBuffer chunk, ByteBuffer content) {
        int mask = 0;
        if (header != null) {
            ++mask;
        }
        if (chunk != null) {
            mask += 2;
        }
        if (content != null) {
            mask += 4;
        }
        EndPoint endPoint = this.connection.getEndPoint();
        switch (mask) {
            case 0: {
                endPoint.write(null, callback, new ByteBuffer[]{BufferUtil.EMPTY_BUFFER});
                break;
            }
            case 1: {
                endPoint.write(null, callback, new ByteBuffer[]{header});
                break;
            }
            case 2: {
                endPoint.write(null, callback, new ByteBuffer[]{chunk});
                break;
            }
            case 3: {
                endPoint.write(null, callback, new ByteBuffer[]{header, chunk});
                break;
            }
            case 4: {
                endPoint.write(null, callback, new ByteBuffer[]{content});
                break;
            }
            case 5: {
                endPoint.write(null, callback, new ByteBuffer[]{header, content});
                break;
            }
            case 6: {
                endPoint.write(null, callback, new ByteBuffer[]{chunk, content});
                break;
            }
            case 7: {
                endPoint.write(null, callback, new ByteBuffer[]{header, chunk, content});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void committed(Request request) {
        LOG.debug("Committed {}", new Object[]{request});
        this.committed = true;
        this.requestNotifier.notifyHeaders(request);
    }

    protected void success() {
        this.generator.reset();
        this.committed = false;
        HttpExchange exchange = this.connection.getExchange();
        Request request = exchange.request();
        LOG.debug("Sent {}", new Object[]{request});
        Result result = exchange.requestComplete(null);
        this.requestNotifier.notifySuccess(request);
        if (result != null) {
            HttpConversation conversation = exchange.conversation();
            this.responseNotifier.notifyComplete(conversation.listener(), result);
        }
    }

    protected void fail(Throwable failure) {
        this.generator.abort();
        this.failed = true;
        HttpExchange exchange = this.connection.getExchange();
        Request request = exchange.request();
        LOG.debug("Failed {} {}", new Object[]{request, failure});
        Result result = exchange.requestComplete(failure);
        if (result == null && !this.committed) {
            result = exchange.responseComplete(null);
        }
        if (result == null) {
            this.connection.getEndPoint().shutdownOutput();
        }
        this.requestNotifier.notifyFailure(request, failure);
        if (result != null) {
            HttpConversation conversation = exchange.conversation();
            this.responseNotifier.notifyComplete(conversation.listener(), result);
        }
    }

    private void releaseBuffers(ByteBufferPool bufferPool, ByteBuffer header, ByteBuffer chunk) {
        if (!BufferUtil.hasContent((ByteBuffer)header)) {
            bufferPool.release(header);
        }
        if (!BufferUtil.hasContent((ByteBuffer)chunk)) {
            bufferPool.release(chunk);
        }
    }

    private class ContentInfo {
        private final CountDownLatch latch = new CountDownLatch(1);
        public final boolean lastContent;
        public final ByteBuffer content;

        public ContentInfo(Iterator<ByteBuffer> contentIterator) {
            this.lastContent = !contentIterator.hasNext();
            this.content = this.lastContent ? BufferUtil.EMPTY_BUFFER : contentIterator.next();
        }

        public void ready() {
            this.latch.countDown();
        }

        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException x) {
                throw new IllegalStateException(x);
            }
        }
    }

    private static abstract class StatefulExecutorCallback
    implements Callback<Void>,
    Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.INCOMPLETE);
        private final Executor executor;

        private StatefulExecutorCallback(Executor executor) {
            this.executor = executor;
        }

        public final void completed(Void context) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.COMPLETE)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(this);
            }
        }

        @Override
        public final void run() {
            this.pendingCompleted();
        }

        protected abstract void pendingCompleted();

        public final void failed(Void context, final Throwable x) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.FAILED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        StatefulExecutorCallback.this.failed(x);
                    }
                });
            } else {
                this.failed(x);
            }
        }

        protected abstract void failed(Throwable var1);

        public boolean pending() {
            return this.state.compareAndSet(State.INCOMPLETE, State.PENDING);
        }

        public boolean completed() {
            return this.state.get() == State.COMPLETE;
        }

        public boolean failed() {
            return this.state.get() == State.FAILED;
        }

        private static enum State {
            INCOMPLETE,
            PENDING,
            COMPLETE,
            FAILED;

        }
    }
}

