/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);
    private final HttpClient client;

    public ResponseNotifier(HttpClient client) {
        this.client = client;
    }

    public void notifyBegin(Response.Listener listener, Response response) {
        try {
            if (listener != null) {
                listener.onBegin(response);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyHeaders(Response.Listener listener, Response response) {
        try {
            if (listener != null) {
                listener.onHeaders(response);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyContent(Response.Listener listener, Response response, ByteBuffer buffer) {
        try {
            if (listener != null) {
                listener.onContent(response, buffer);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifySuccess(Response.Listener listener, Response response) {
        try {
            if (listener != null) {
                listener.onSuccess(response);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyFailure(Response.Listener listener, Response response, Throwable failure) {
        try {
            if (listener != null) {
                listener.onFailure(response, failure);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyComplete(Response.Listener listener, Result result) {
        try {
            if (listener != null) {
                listener.onComplete(result);
            }
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void forwardSuccess(Response.Listener listener, Response response) {
        this.notifyBegin(listener, response);
        this.notifyHeaders(listener, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listener, response, ByteBuffer.wrap(((ContentResponse)response).content()));
        }
        this.notifySuccess(listener, response);
    }

    public void forwardSuccessComplete(Response.Listener listener, Request request, Response response) {
        HttpConversation conversation = this.client.getConversation(request.conversation());
        this.forwardSuccess(listener, response);
        conversation.complete();
        this.notifyComplete(listener, new Result(request, response));
    }

    public void forwardFailure(Response.Listener listener, Response response, Throwable failure) {
        this.notifyBegin(listener, response);
        this.notifyHeaders(listener, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listener, response, ByteBuffer.wrap(((ContentResponse)response).content()));
        }
        this.notifyFailure(listener, response, failure);
    }

    public void forwardFailureComplete(Response.Listener listener, Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        HttpConversation conversation = this.client.getConversation(request.conversation());
        this.forwardFailure(listener, response, responseFailure);
        conversation.complete();
        this.notifyComplete(listener, new Result(request, requestFailure, response, responseFailure));
    }
}

