/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;

public class BufferingResponseListener
extends Response.Listener.Empty {
    private final int maxLength;
    private volatile byte[] buffer = new byte[0];
    private volatile String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void onHeaders(Response response) {
        String contentType;
        HttpFields headers = response.headers();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (length > (long)this.maxLength) {
            response.abort();
        }
        if ((contentType = headers.get(HttpHeader.CONTENT_TYPE)) != null) {
            String charset = "charset=";
            int index = contentType.toLowerCase().indexOf(charset);
            if (index > 0) {
                String encoding = contentType.substring(index + charset.length());
                if ((index = encoding.indexOf(59)) > 0) {
                    encoding = encoding.substring(0, index);
                }
                this.encoding = encoding;
            }
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        long newLength = this.buffer.length + content.remaining();
        if (newLength > (long)this.maxLength) {
            throw new IllegalStateException("Buffering capacity exceeded");
        }
        byte[] newBuffer = new byte[(int)newLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        content.get(newBuffer, this.buffer.length, content.remaining());
        this.buffer = newBuffer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        return this.buffer;
    }

    public String getContentAsString() {
        String encoding = this.encoding;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return this.getContentAsString(encoding);
    }

    public String getContentAsString(String encoding) {
        try {
            return new String(this.getContent(), encoding);
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(encoding);
        }
    }
}

