/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamResponseListener
extends Response.Listener.Empty {
    public static final Logger LOG = Log.getLogger(InputStreamResponseListener.class);
    private static final byte[] EOF = new byte[0];
    private static final byte[] FAILURE = new byte[0];
    private final BlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
    private final AtomicLong length = new AtomicLong();
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final long capacity;
    private Response response;
    private Result result;
    private volatile Throwable failure;

    public InputStreamResponseListener() {
        this(16384L);
    }

    public InputStreamResponseListener(long capacity) {
        this.capacity = capacity;
    }

    @Override
    public void onHeaders(Response response) {
        this.response = response;
        this.responseLatch.countDown();
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        int remaining = content.remaining();
        byte[] bytes = new byte[remaining];
        content.get(bytes);
        LOG.debug("Queued {}/{} bytes", new Object[]{bytes, bytes.length});
        this.queue.offer(bytes);
        long newLength = this.length.addAndGet(remaining);
        while (newLength >= this.capacity) {
            LOG.debug("Queued bytes limit {}/{} exceeded, waiting", new Object[]{newLength, this.capacity});
            if (!this.await()) break;
            newLength = this.length.get();
            LOG.debug("Queued bytes limit {}/{} exceeded, woken up", new Object[]{newLength, this.capacity});
        }
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        this.failure = failure;
        this.queue.offer(FAILURE);
        LOG.debug("Queued failure {} {}", new Object[]{FAILURE, failure});
        this.responseLatch.countDown();
    }

    @Override
    public void onSuccess(Response response) {
        this.queue.offer(EOF);
        LOG.debug("Queued end of content {}{}", new Object[]{EOF, ""});
    }

    @Override
    public void onComplete(Result result) {
        this.result = result;
        this.resultLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await() {
        try {
            InputStreamResponseListener inputStreamResponseListener = this;
            synchronized (inputStreamResponseListener) {
                this.wait();
            }
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal() {
        InputStreamResponseListener inputStreamResponseListener = this;
        synchronized (inputStreamResponseListener) {
            this.notify();
        }
    }

    public Response get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean expired;
        boolean bl = expired = !this.responseLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.response;
    }

    public Result await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.resultLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        return this.result;
    }

    public InputStream getInputStream() {
        return new Input();
    }

    private class Input
    extends InputStream {
        private byte[] bytes;
        private int index;

        private Input() {
        }

        @Override
        public int read() throws IOException {
            while (true) {
                if (this.bytes != null) {
                    if (this.index < this.bytes.length) {
                        return this.bytes[this.index++];
                    }
                    InputStreamResponseListener.this.length.addAndGet(-this.index);
                    this.bytes = null;
                    this.index = 0;
                }
                this.bytes = this.take();
                LOG.debug("Dequeued {}/{} bytes", new Object[]{this.bytes, this.bytes.length});
                if (this.bytes == EOF) {
                    return -1;
                }
                if (this.bytes == FAILURE) {
                    if (InputStreamResponseListener.this.failure instanceof IOException) {
                        throw (IOException)InputStreamResponseListener.this.failure;
                    }
                    throw new IOException(InputStreamResponseListener.this.failure);
                }
                InputStreamResponseListener.this.signal();
            }
        }

        private byte[] take() throws IOException {
            try {
                return (byte[])InputStreamResponseListener.this.queue.take();
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }
    }
}

