/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpCookie;

public class HttpCookieParser {
    private static final String[] DATE_PATTERNS = new String[]{"EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE MMM dd yyyy HH:mm:ss 'GMT'Z"};

    private HttpCookieParser() {
    }

    public static List<HttpCookie> parseCookies(String headerValue) {
        if (headerValue.toLowerCase(Locale.ENGLISH).contains("expires=")) {
            HttpCookie cookie = HttpCookieParser.parseCookie(headerValue, 0);
            if (cookie != null) {
                return Collections.singletonList(cookie);
            }
            return Collections.emptyList();
        }
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        List<String> cookieStrings = HttpCookieParser.splitCookies(headerValue);
        for (String cookieString : cookieStrings) {
            HttpCookie cookie = HttpCookieParser.parseCookie(cookieString, 1);
            if (cookie == null) continue;
            result.add(cookie);
        }
        return result;
    }

    private static List<String> splitCookies(String headerValue) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int quotes = 0;
        for (int i = 0; i < headerValue.length(); ++i) {
            char c = headerValue.charAt(i);
            if (c == ',' && quotes % 2 == 0) {
                result.add(headerValue.substring(start, i));
                start = i + 1;
                continue;
            }
            if (c != '\"') continue;
            ++quotes;
        }
        result.add(headerValue.substring(start));
        return result;
    }

    private static HttpCookie parseCookie(String cookieString, int version) {
        String[] cookieParts = cookieString.split(";");
        String nameValue = cookieParts[0];
        int equal = nameValue.indexOf(61);
        if (equal < 1) {
            return null;
        }
        String name = nameValue.substring(0, equal).trim();
        String value = nameValue.substring(equal + 1);
        String domain = null;
        String path = "/";
        long maxAge = -1L;
        boolean httpOnly = false;
        boolean secure = false;
        String comment = null;
        for (int i = 1; i < cookieParts.length; ++i) {
            try {
                String[] attributeParts = cookieParts[i].split("=", 2);
                String attributeName = attributeParts[0].trim().toLowerCase(Locale.ENGLISH);
                String attributeValue = attributeParts.length < 2 ? "" : attributeParts[1].trim();
                switch (attributeName) {
                    case "domain": {
                        domain = attributeValue;
                        break;
                    }
                    case "path": {
                        path = attributeValue;
                        break;
                    }
                    case "max-age": {
                        maxAge = Long.parseLong(attributeValue);
                        break;
                    }
                    case "expires": {
                        maxAge = HttpCookieParser.parseDate(attributeValue);
                        break;
                    }
                    case "secure": {
                        secure = true;
                        break;
                    }
                    case "httponly": {
                        httpOnly = true;
                    }
                    case "comment": {
                        comment = attributeValue;
                        break;
                    }
                    case "version": {
                        version = Integer.parseInt(attributeValue);
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        return new HttpCookie(name, value, domain, path, maxAge, httpOnly, secure, comment, version);
    }

    private static long parseDate(String attributeValue) {
        for (String pattern : DATE_PATTERNS) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.US);
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                long result = TimeUnit.MILLISECONDS.toSeconds(dateFormat.parse(attributeValue).getTime() - System.currentTimeMillis());
                if (result >= 0L) continue;
                return 0L;
            }
            catch (ParseException x) {
                // empty catch block
            }
        }
        return 0L;
    }
}

