/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Fields;

public interface Request {
    public long getConversationID();

    public String getScheme();

    public Request scheme(String var1);

    public String getHost();

    public int getPort();

    public HttpMethod getMethod();

    public Request method(HttpMethod var1);

    public String getPath();

    public Request path(String var1);

    public String getURI();

    public HttpVersion getVersion();

    public Request version(HttpVersion var1);

    public Fields getParams();

    public Request param(String var1, String var2);

    public HttpFields getHeaders();

    public Request header(String var1, String var2);

    public Request attribute(String var1, Object var2);

    public Map<String, Object> getAttributes();

    public ContentProvider getContent();

    public Request content(ContentProvider var1);

    public Request file(Path var1) throws IOException;

    public Request file(Path var1, String var2) throws IOException;

    public String getAgent();

    public Request agent(String var1);

    public long getIdleTimeout();

    public Request idleTimeout(long var1);

    public boolean isFollowRedirects();

    public Request followRedirects(boolean var1);

    public <T extends RequestListener> List<T> getRequestListeners(Class<T> var1);

    public Request listener(Listener var1);

    public Request onRequestQueued(QueuedListener var1);

    public Request onRequestBegin(BeginListener var1);

    public Request onRequestHeaders(HeadersListener var1);

    public Request onRequestSuccess(SuccessListener var1);

    public Request onRequestFailure(FailureListener var1);

    public Request onResponseBegin(Response.BeginListener var1);

    public Request onResponseHeaders(Response.HeadersListener var1);

    public Request onResponseContent(Response.ContentListener var1);

    public Request onResponseSuccess(Response.SuccessListener var1);

    public Request onResponseFailure(Response.FailureListener var1);

    public Future<ContentResponse> send();

    public void send(Response.CompleteListener var1);

    public boolean abort(String var1);

    public boolean isAborted();

    public static interface Listener
    extends QueuedListener,
    BeginListener,
    HeadersListener,
    SuccessListener,
    FailureListener {

        public static class Empty
        implements Listener {
            @Override
            public void onQueued(Request request) {
            }

            @Override
            public void onBegin(Request request) {
            }

            @Override
            public void onHeaders(Request request) {
            }

            @Override
            public void onSuccess(Request request) {
            }

            @Override
            public void onFailure(Request request, Throwable failure) {
            }
        }
    }

    public static interface FailureListener
    extends RequestListener {
        public void onFailure(Request var1, Throwable var2);
    }

    public static interface SuccessListener
    extends RequestListener {
        public void onSuccess(Request var1);
    }

    public static interface HeadersListener
    extends RequestListener {
        public void onHeaders(Request var1);
    }

    public static interface BeginListener
    extends RequestListener {
        public void onBegin(Request var1);
    }

    public static interface QueuedListener
    extends RequestListener {
        public void onQueued(Request var1);
    }

    public static interface RequestListener
    extends EventListener {
    }
}

