/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public interface Response {
    public long getConversationID();

    public <T extends ResponseListener> List<T> getListeners(Class<T> var1);

    public HttpVersion getVersion();

    public int getStatus();

    public String getReason();

    public HttpFields getHeaders();

    public boolean abort(String var1);

    public static interface Listener
    extends BeginListener,
    HeadersListener,
    ContentListener,
    SuccessListener,
    FailureListener,
    CompleteListener {

        public static class Empty
        implements Listener {
            @Override
            public void onBegin(Response response) {
            }

            @Override
            public void onHeaders(Response response) {
            }

            @Override
            public void onContent(Response response, ByteBuffer content) {
            }

            @Override
            public void onSuccess(Response response) {
            }

            @Override
            public void onFailure(Response response, Throwable failure) {
            }

            @Override
            public void onComplete(Result result) {
            }
        }
    }

    public static interface CompleteListener
    extends ResponseListener {
        public void onComplete(Result var1);
    }

    public static interface FailureListener
    extends ResponseListener {
        public void onFailure(Response var1, Throwable var2);
    }

    public static interface SuccessListener
    extends ResponseListener {
        public void onSuccess(Response var1);
    }

    public static interface ContentListener
    extends ResponseListener {
        public void onContent(Response var1, ByteBuffer var2);
    }

    public static interface HeadersListener
    extends ResponseListener {
        public void onHeaders(Response var1);
    }

    public static interface BeginListener
    extends ResponseListener {
        public void onBegin(Response var1);
    }

    public static interface ResponseListener
    extends EventListener {
    }
}

