/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;

public class InputStreamContentProvider
implements ContentProvider {
    private final InputStream stream;
    private final int bufferSize;

    public InputStreamContentProvider(InputStream stream) {
        this(stream, 4096);
    }

    public InputStreamContentProvider(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.bufferSize = bufferSize;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private final byte[] buffer;
            public boolean eof;
            {
                this.buffer = new byte[InputStreamContentProvider.this.bufferSize];
            }

            @Override
            public boolean hasNext() {
                return !this.eof;
            }

            @Override
            public ByteBuffer next() {
                try {
                    int read = InputStreamContentProvider.this.stream.read(this.buffer);
                    if (read > 0) {
                        return ByteBuffer.wrap(this.buffer, 0, read);
                    }
                    if (read < 0) {
                        if (this.eof) {
                            throw new NoSuchElementException();
                        }
                        this.eof = true;
                        return BufferUtil.EMPTY_BUFFER;
                    }
                    return BufferUtil.EMPTY_BUFFER;
                }
                catch (IOException x) {
                    throw (NoSuchElementException)new NoSuchElementException().initCause(x);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

