/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.client.api.CookieStore;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.http.HttpCookie;

public class HttpCookieStore
implements CookieStore {
    private final ConcurrentMap<String, Queue<HttpCookie>> allCookies = new ConcurrentHashMap<String, Queue<HttpCookie>>();

    @Override
    public List<HttpCookie> findCookies(Destination destination, String path) {
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        String host = destination.getHost();
        int port = destination.getPort();
        String key = host + ":" + port;
        Queue cookies = (Queue)this.allCookies.get(key + "/");
        if (cookies != null) {
            this.accumulateCookies(destination, cookies, result);
        }
        String[] split = path.split("/");
        for (int i = 1; i < split.length; ++i) {
            String segment = split[i];
            cookies = (Queue)this.allCookies.get(key = key + "/" + segment);
            if (cookies != null) {
                this.accumulateCookies(destination, cookies, result);
            }
            if (segment.length() <= 0) continue;
            key = key + "/";
        }
        int domains = host.split("\\.").length - 1;
        for (int i = 2; i <= domains; ++i) {
            String[] hostParts = host.split("\\.", i);
            key = (host = hostParts[hostParts.length - 1]) + ":" + port + "/";
            cookies = (Queue)this.allCookies.get(key);
            if (cookies == null) continue;
            this.accumulateCookies(destination, cookies, result);
        }
        return result;
    }

    private void accumulateCookies(Destination destination, Queue<HttpCookie> cookies, List<HttpCookie> result) {
        Iterator iterator = cookies.iterator();
        while (iterator.hasNext()) {
            HttpCookie cookie = (HttpCookie)iterator.next();
            if (cookie.isExpired(System.nanoTime())) {
                iterator.remove();
                continue;
            }
            if (!"https".equalsIgnoreCase(destination.getScheme()) && cookie.isSecure()) continue;
            result.add(cookie);
        }
    }

    @Override
    public boolean addCookie(Destination destination, HttpCookie cookie) {
        Queue existing;
        String key;
        Queue<Object> cookies;
        String destinationDomain = destination.getHost() + ":" + destination.getPort();
        String domain = cookie.getDomain();
        if (domain == null) {
            domain = destinationDomain;
        }
        if (domain.indexOf(58) < 0) {
            domain = domain + ":" + ("https".equalsIgnoreCase(destination.getScheme()) ? 443 : 80);
        }
        if (!domain.endsWith(destinationDomain)) {
            return false;
        }
        String path = cookie.getPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if ((cookies = (ConcurrentLinkedQueue<HttpCookie>)this.allCookies.get(key = destination.getHost() + ":" + destination.getPort() + path)) == null && (existing = (Queue)this.allCookies.putIfAbsent(key, cookies = new ConcurrentLinkedQueue<HttpCookie>())) != null) {
            cookies = existing;
        }
        cookies.add(cookie);
        return true;
    }

    @Override
    public void clear() {
        this.allCookies.clear();
    }
}

