/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.ProxyConfiguration;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.TimedResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpDestination
implements Destination,
AutoCloseable,
Dumpable {
    private static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final AtomicInteger connectionCount = new AtomicInteger();
    private final HttpClient client;
    private final String scheme;
    private final InetSocketAddress address;
    private final Queue<RequestContext> requests;
    private final BlockingQueue<Connection> idleConnections;
    private final BlockingQueue<Connection> activeConnections;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final InetSocketAddress proxyAddress;

    public HttpDestination(HttpClient client, String scheme, String host, int port) {
        this.client = client;
        this.scheme = scheme;
        this.address = new InetSocketAddress(host, port);
        this.requests = new ArrayBlockingQueue<RequestContext>(client.getMaxQueueSizePerAddress());
        this.idleConnections = new ArrayBlockingQueue<Connection>(client.getMaxConnectionsPerAddress());
        this.activeConnections = new ArrayBlockingQueue<Connection>(client.getMaxConnectionsPerAddress());
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier(client);
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxyAddress = proxyConfig != null && proxyConfig.matches(host, port) ? new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort()) : null;
    }

    protected BlockingQueue<Connection> getIdleConnections() {
        return this.idleConnections;
    }

    protected BlockingQueue<Connection> getActiveConnections() {
        return this.activeConnections;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.address.getHostString();
    }

    @Override
    public int getPort() {
        return this.address.getPort();
    }

    public InetSocketAddress getConnectAddress() {
        return this.isProxied() ? this.proxyAddress : this.address;
    }

    public boolean isProxied() {
        return this.proxyAddress != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(Request request, List<Response.ResponseListener> listeners) {
        if (!this.scheme.equals(request.getScheme())) {
            throw new IllegalArgumentException("Invalid request scheme " + request.getScheme() + " for destination " + this);
        }
        if (!this.getHost().equals(request.getHost())) {
            throw new IllegalArgumentException("Invalid request host " + request.getHost() + " for destination " + this);
        }
        int port = request.getPort();
        if (port >= 0 && this.getPort() != port) {
            throw new IllegalArgumentException("Invalid request port " + port + " for destination " + this);
        }
        RequestContext requestContext = new RequestContext(request, listeners);
        if (!this.client.isRunning()) throw new RejectedExecutionException((Object)((Object)this.client) + " is stopped");
        if (!this.requests.offer(requestContext)) throw new RejectedExecutionException("Max requests per address " + this.client.getMaxQueueSizePerAddress() + " exceeded");
        if (!this.client.isRunning() && this.requests.remove(requestContext)) {
            throw new RejectedExecutionException((Object)((Object)this.client) + " is stopping");
        }
        LOG.debug("Queued {}", new Object[]{request});
        this.requestNotifier.notifyQueued(request);
        Connection connection = this.acquire();
        if (connection == null) return;
        this.process(connection, false);
    }

    @Override
    public Future<Connection> newConnection() {
        FutureCallback result = new FutureCallback();
        this.newConnection(new CONNECTCallback((Callback)result));
        return result;
    }

    protected void newConnection(Callback<Connection> callback) {
        this.client.newConnection(this, callback);
    }

    protected Connection acquire() {
        int next;
        int current;
        Connection result = (Connection)this.idleConnections.poll();
        if (result != null) {
            return result;
        }
        int maxConnections = this.client.getMaxConnectionsPerAddress();
        do {
            if ((next = (current = this.connectionCount.get()) + 1) <= maxConnections) continue;
            LOG.debug("Max connections {} reached for {}", new Object[]{current, this});
            return (Connection)this.idleConnections.poll();
        } while (!this.connectionCount.compareAndSet(current, next));
        LOG.debug("Creating connection {}/{} for {}", new Object[]{next, maxConnections, this});
        CONNECTCallback connectCallback = new CONNECTCallback((Callback)new Callback<Connection>(){

            public void completed(Connection connection) {
                HttpDestination.this.process(connection, true);
            }

            public void failed(final Connection connection, final Throwable x) {
                HttpDestination.this.client.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        HttpDestination.this.drain(x);
                        if (connection != null) {
                            connection.close();
                        }
                    }
                });
            }
        });
        this.newConnection(new TCPCallback(next, maxConnections, connectCallback));
        return (Connection)this.idleConnections.poll();
    }

    private void drain(Throwable x) {
        RequestContext requestContext;
        while ((requestContext = this.requests.poll()) != null) {
            Request request = requestContext.request;
            this.requestNotifier.notifyFailure(request, x);
            List listeners = requestContext.listeners;
            HttpResponse response = new HttpResponse(request, listeners);
            this.responseNotifier.notifyFailure(listeners, (Response)response, x);
            this.responseNotifier.notifyComplete(listeners, new Result(request, x, response, x));
        }
    }

    protected void process(Connection connection, boolean dispatch) {
        final HttpConnection httpConnection = (HttpConnection)connection;
        RequestContext requestContext = this.requests.poll();
        if (requestContext == null) {
            LOG.debug("{} idle", new Object[]{httpConnection});
            if (!this.idleConnections.offer(httpConnection)) {
                LOG.debug("{} idle overflow", new Object[0]);
                httpConnection.close();
            }
            if (!this.client.isRunning()) {
                LOG.debug("{} is stopping", new Object[]{this.client});
                this.remove(httpConnection);
                httpConnection.close();
            }
        } else {
            final Request request = requestContext.request;
            final List listeners = requestContext.listeners;
            Throwable cause = request.getAbortCause();
            if (cause != null) {
                this.abort(request, listeners, cause);
                LOG.debug("Aborted {} before processing", new Object[]{request});
            } else {
                LOG.debug("{} active", new Object[]{httpConnection});
                if (!this.activeConnections.offer(httpConnection)) {
                    LOG.warn("{} active overflow", new Object[0]);
                }
                if (dispatch) {
                    this.client.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            httpConnection.send(request, listeners);
                        }
                    });
                } else {
                    httpConnection.send(request, listeners);
                }
            }
        }
    }

    public void release(Connection connection) {
        LOG.debug("{} released", new Object[]{connection});
        if (this.client.isRunning()) {
            boolean removed = this.activeConnections.remove(connection);
            if (removed) {
                this.process(connection, false);
            } else {
                LOG.debug("{} explicit", new Object[]{connection});
            }
        } else {
            LOG.debug("{} is stopped", new Object[]{this.client});
            this.remove(connection);
            connection.close();
        }
    }

    public void remove(Connection connection) {
        boolean removed = this.activeConnections.remove(connection);
        if (removed |= this.idleConnections.remove(connection)) {
            LOG.debug("{} removed", new Object[]{connection});
            this.connectionCount.decrementAndGet();
        }
        if (!this.requests.isEmpty() && (connection = this.acquire()) != null) {
            this.process(connection, false);
        }
    }

    @Override
    public void close() {
        for (Connection connection : this.idleConnections) {
            connection.close();
        }
        this.idleConnections.clear();
        for (Connection connection : this.activeConnections) {
            connection.close();
        }
        this.activeConnections.clear();
        this.drain(new AsynchronousCloseException());
        this.connectionCount.set(0);
        LOG.debug("Closed {}", new Object[]{this});
    }

    public boolean abort(Request request, Throwable cause) {
        for (RequestContext requestContext : this.requests) {
            if (requestContext.request != request || !this.requests.remove(requestContext)) continue;
            this.abort(request, requestContext.listeners, cause);
            LOG.debug("Aborted {} while queued", new Object[]{request});
            return true;
        }
        return false;
    }

    private void abort(Request request, List<Response.ResponseListener> listeners, Throwable cause) {
        HttpResponse response = new HttpResponse(request, listeners);
        this.responseNotifier.notifyFailure(listeners, (Response)response, cause);
        this.responseNotifier.notifyComplete(listeners, new Result(request, cause, response, cause));
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)(this + " - requests queued: " + this.requests.size()));
        ArrayList<String> connections = new ArrayList<String>();
        for (Connection connection : this.idleConnections) {
            connections.add(connection + " - IDLE");
        }
        for (Connection connection : this.activeConnections) {
            connections.add(connection + " - ACTIVE");
        }
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{connections});
    }

    public String toString() {
        return String.format("%s(%s://%s:%d)%s", HttpDestination.class.getSimpleName(), this.getScheme(), this.getHost(), this.getPort(), this.proxyAddress == null ? "" : " via " + this.proxyAddress.getHostString() + ":" + this.proxyAddress.getPort());
    }

    private class CONNECTCallback
    implements Callback<Connection> {
        private final Callback<Connection> delegate;

        private CONNECTCallback(Callback<Connection> delegate) {
            this.delegate = delegate;
        }

        public void completed(Connection connection) {
            boolean tunnel;
            boolean bl = tunnel = HttpDestination.this.isProxied() && "https".equalsIgnoreCase(HttpDestination.this.getScheme()) && HttpDestination.this.client.getSslContextFactory() != null;
            if (tunnel) {
                this.tunnel(connection);
            } else {
                this.delegate.completed((Object)connection);
            }
        }

        public void failed(Connection connection, Throwable x) {
            this.delegate.failed((Object)connection, x);
        }

        private void tunnel(final Connection connection) {
            String target = HttpDestination.this.address.getHostString() + ":" + HttpDestination.this.address.getPort();
            Request connect = HttpDestination.this.client.newRequest(HttpDestination.this.proxyAddress.getHostString(), HttpDestination.this.proxyAddress.getPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST.asString(), target);
            connection.send(connect, new TimedResponseListener(HttpDestination.this.client.getConnectTimeout(), TimeUnit.MILLISECONDS, connect, new Response.CompleteListener(){

                @Override
                public void onComplete(Result result) {
                    if (result.isFailed()) {
                        CONNECTCallback.this.failed(connection, result.getFailure());
                    } else {
                        Response response = result.getResponse();
                        if (response.getStatus() == 200) {
                            CONNECTCallback.this.delegate.completed((Object)connection);
                        } else {
                            CONNECTCallback.this.failed(connection, (Throwable)new HttpResponseException("Received " + response + " for " + result.getRequest(), response));
                        }
                    }
                }
            }));
        }
    }

    private class TCPCallback
    implements Callback<Connection> {
        private final int current;
        private final int max;
        private final Callback<Connection> delegate;

        private TCPCallback(int current, int max, Callback<Connection> delegate) {
            this.current = current;
            this.max = max;
            this.delegate = delegate;
        }

        public void completed(Connection connection) {
            LOG.debug("Created connection {}/{} {} for {}", new Object[]{this.current, this.max, connection, HttpDestination.this});
            this.delegate.completed((Object)connection);
        }

        public void failed(Connection connection, Throwable x) {
            LOG.debug("Connection failed {} for {}", new Object[]{x, HttpDestination.this});
            HttpDestination.this.connectionCount.decrementAndGet();
            this.delegate.failed((Object)connection, x);
        }
    }

    private static class RequestContext {
        private final Request request;
        private final List<Response.ResponseListener> listeners;

        private RequestContext(Request request, List<Response.ResponseListener> listeners) {
            this.request = request;
            this.listeners = listeners;
        }
    }
}

