/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BlockingResponseListener;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Fields;

public class HttpRequest
implements Request {
    private static final AtomicLong ids = new AtomicLong();
    private final HttpFields headers = new HttpFields();
    private final Fields params = new Fields();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final List<Request.RequestListener> requestListeners = new ArrayList<Request.RequestListener>();
    private final List<Response.ResponseListener> responseListeners = new ArrayList<Response.ResponseListener>();
    private final HttpClient client;
    private final long conversation;
    private final String host;
    private final int port;
    private String scheme;
    private String path;
    private HttpMethod method;
    private HttpVersion version;
    private long idleTimeout;
    private ContentProvider content;
    private boolean followRedirects;
    private volatile Throwable aborted;

    public HttpRequest(HttpClient client, URI uri) {
        this(client, ids.incrementAndGet(), uri);
    }

    protected HttpRequest(HttpClient client, long conversation, URI uri) {
        this.client = client;
        this.conversation = conversation;
        this.scheme(uri.getScheme());
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path(uri.getPath());
        String query = uri.getRawQuery();
        if (query != null) {
            for (String nameValue : query.split("&")) {
                String[] parts = nameValue.split("=");
                this.param(parts[0], parts.length < 2 ? "" : this.urlDecode(parts[1]));
            }
        }
        this.followRedirects(client.isFollowRedirects());
    }

    private String urlDecode(String value) {
        String charset = "UTF-8";
        try {
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(charset);
        }
    }

    @Override
    public long getConversationID() {
        return this.conversation;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public Request scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public Request method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Request path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String getURI() {
        String scheme = this.getScheme();
        String result = scheme + "://" + this.getHost();
        int port = this.getPort();
        result = result + ("http".equals(scheme) && port != 80 ? ":" + port : "");
        result = result + ("https".equals(scheme) && port != 443 ? ":" + port : "");
        result = result + this.getPath();
        return result;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    @Override
    public Request version(HttpVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public Request param(String name, String value) {
        this.params.add(name, value);
        return this;
    }

    @Override
    public Fields getParams() {
        return this.params;
    }

    @Override
    public String getAgent() {
        return this.headers.get(HttpHeader.USER_AGENT);
    }

    @Override
    public Request agent(String agent) {
        this.headers.put(HttpHeader.USER_AGENT, agent);
        return this;
    }

    @Override
    public Request header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.add(name, value);
        }
        return this;
    }

    @Override
    public Request attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    @Override
    public <T extends Request.RequestListener> List<T> getRequestListeners(Class<T> type) {
        ArrayList<Request.RequestListener> result = new ArrayList<Request.RequestListener>();
        for (Request.RequestListener listener : this.requestListeners) {
            if (type != null && !type.isInstance(listener)) continue;
            result.add(listener);
        }
        return result;
    }

    @Override
    public Request listener(Request.Listener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestQueued(Request.QueuedListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestBegin(Request.BeginListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestHeaders(Request.HeadersListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestSuccess(Request.SuccessListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestFailure(Request.FailureListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseBegin(Response.BeginListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseHeaders(Response.HeadersListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseContent(Response.ContentListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseSuccess(Response.SuccessListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseFailure(Response.FailureListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public ContentProvider getContent() {
        return this.content;
    }

    @Override
    public Request content(ContentProvider content) {
        this.content = content;
        return this;
    }

    @Override
    public Request file(Path file) throws IOException {
        return this.file(file, "application/octet-stream");
    }

    @Override
    public Request file(Path file, String contentType) throws IOException {
        if (contentType != null) {
            this.header(HttpHeader.CONTENT_TYPE.asString(), contentType);
        }
        return this.content(new PathContentProvider(file));
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public Request followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Request idleTimeout(long timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    @Override
    public Future<ContentResponse> send() {
        BlockingResponseListener listener = new BlockingResponseListener(this);
        this.send(listener);
        return listener;
    }

    @Override
    public void send(Response.CompleteListener listener) {
        if (listener != null) {
            this.responseListeners.add(listener);
        }
        this.client.send(this, this.responseListeners);
    }

    @Override
    public boolean abort(Throwable cause) {
        this.aborted = Objects.requireNonNull(cause);
        if (this.client.provideDestination(this.getScheme(), this.getHost(), this.getPort()).abort(this, cause)) {
            return true;
        }
        HttpConversation conversation = this.client.getConversation(this.getConversationID(), false);
        return conversation != null && conversation.abort(cause);
    }

    @Override
    public Throwable getAbortCause() {
        return this.aborted;
    }

    public String toString() {
        return String.format("%s[%s %s %s]@%x", HttpRequest.class.getSimpleName(), this.getMethod(), this.getPath(), this.getVersion(), this.hashCode());
    }
}

