/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpSender {
    private static final Logger LOG = Log.getLogger(HttpSender.class);
    private static final String EXPECT_100_ATTRIBUTE = HttpSender.class.getName() + ".expect100";
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpConnection connection;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private Iterator<ByteBuffer> contentIterator;
    private ContentInfo expectedContent;

    public HttpSender(HttpConnection connection) {
        this.connection = connection;
        this.requestNotifier = new RequestNotifier(connection.getHttpClient());
        this.responseNotifier = new ResponseNotifier(connection.getHttpClient());
    }

    public void send(HttpExchange exchange) {
        if (!this.updateState(State.IDLE, State.SEND)) {
            throw new IllegalStateException();
        }
        HttpConversation conversation = exchange.getConversation();
        HttpExchange initialExchange = conversation.getExchanges().peekFirst();
        if (initialExchange == exchange) {
            conversation.setResponseListeners(exchange.getResponseListeners());
        } else {
            ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(exchange.getResponseListeners());
            listeners.addAll(initialExchange.getResponseListeners());
            conversation.setResponseListeners(listeners);
        }
        Request request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            exchange.abort(cause);
        } else {
            LOG.debug("Sending {}", new Object[]{request});
            this.requestNotifier.notifyBegin(request);
            ContentProvider content = request.getContent();
            this.contentIterator = content == null ? Collections.emptyIterator() : content.iterator();
            this.send();
        }
    }

    public void proceed(boolean proceed) {
        ContentInfo contentInfo = this.expectedContent;
        if (contentInfo != null) {
            if (proceed) {
                LOG.debug("Proceeding {}", new Object[]{this.connection.getExchange()});
                contentInfo.await();
                this.send();
            } else {
                HttpExchange exchange = this.connection.getExchange();
                if (exchange != null) {
                    this.fail(new HttpRequestException("Expectation failed", exchange.getRequest()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void send() {
        client = this.connection.getHttpClient();
        bufferPool = client.getByteBufferPool();
        header = null;
        chunk = null;
        try {
            exchange = this.connection.getExchange();
            if (exchange == null) {
                this.releaseBuffers(bufferPool, header, chunk);
                return;
            }
            request = exchange.getRequest();
            conversation = exchange.getConversation();
            requestInfo = null;
            expect100 = request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            if (expect100 &= conversation.getAttribute(HttpSender.EXPECT_100_ATTRIBUTE) == null) {
                conversation.setAttribute(HttpSender.EXPECT_100_ATTRIBUTE, Boolean.TRUE);
            }
            contentInfo = this.expectedContent;
            this.expectedContent = null;
            if (contentInfo == null) {
                contentInfo = new ContentInfo(this.contentIterator);
            } else {
                expect100 = false;
            }
            block23: while (true) {
                result = this.generator.generateRequest(requestInfo, header, chunk, contentInfo.content, contentInfo.lastContent);
                switch (2.$SwitchMap$org$eclipse$jetty$http$HttpGenerator$Result[result.ordinal()]) {
                    case 1: {
                        content = request.getContent();
                        contentLength = content == null ? -1L : content.getLength();
                        requestInfo = new HttpGenerator.RequestInfo(request.getVersion(), request.getHeaders(), contentLength, request.getMethod().asString(), request.getPath());
                        continue block23;
                    }
                    case 2: {
                        header = bufferPool.acquire(client.getRequestBufferSize(), false);
                        continue block23;
                    }
                    case 3: {
                        chunk = bufferPool.acquire(12, false);
                        continue block23;
                    }
                    case 4: {
                        switch (2.$SwitchMap$org$eclipse$jetty$client$HttpSender$State[this.state.get().ordinal()]) {
                            case 1: 
                            case 2: {
                                ** break;
                            }
                            default: {
                                this.releaseBuffers(bufferPool, header, chunk);
                                return;
lbl43:
                                // 1 sources

                                break;
                            }
                        }
                        callback = new StatefulExecutorCallback(client.getExecutor()){

                            @Override
                            protected void pendingCompleted() {
                                LOG.debug("Write completed for {}", new Object[]{request});
                                if (!HttpSender.this.commit(request)) {
                                    return;
                                }
                                if (HttpSender.this.expectedContent == null) {
                                    HttpSender.this.send();
                                } else {
                                    LOG.debug("Expecting 100 Continue for {}", new Object[]{request});
                                    HttpSender.this.expectedContent.ready();
                                }
                            }

                            @Override
                            protected void failed(Throwable x) {
                                HttpSender.this.fail(x);
                            }
                        };
                        if (expect100) {
                            this.expectedContent = contentInfo;
                        }
                        this.write(callback, header, chunk, expect100 != false ? null : contentInfo.content);
                        if (callback.pending()) {
                            HttpSender.LOG.debug("Write pending for {}", new Object[]{request});
                            this.releaseBuffers(bufferPool, header, chunk);
                            return;
                        }
                        if (!callback.completed()) continue block23;
                        if (!this.commit(request)) {
                            this.releaseBuffers(bufferPool, header, chunk);
                            return;
                        }
                        if (expect100) {
                            HttpSender.LOG.debug("Expecting 100 Continue for {}", new Object[]{request});
                            this.expectedContent.ready();
                            this.releaseBuffers(bufferPool, header, chunk);
                            return;
                        }
                        contentInfo = new ContentInfo(this.contentIterator);
                        continue block23;
                    }
                    case 5: {
                        endPoint = this.connection.getEndPoint();
                        endPoint.shutdownOutput();
                        continue block23;
                    }
                    case 6: {
                        continue block23;
                    }
                    case 7: {
                        if (this.generator.isEnd()) {
                            this.success();
                        }
                        this.releaseBuffers(bufferPool, header, chunk);
                        return;
                    }
                }
                break;
            }
            try {
                throw new IllegalStateException("Unknown result " + result);
            }
            catch (Exception x) {
                HttpSender.LOG.debug((Throwable)x);
                this.fail(x);
                return;
            }
        }
        finally {
            this.releaseBuffers(bufferPool, header, chunk);
        }
    }

    private void write(Callback<Void> callback, ByteBuffer header, ByteBuffer chunk, ByteBuffer content) {
        int mask = 0;
        if (header != null) {
            ++mask;
        }
        if (chunk != null) {
            mask += 2;
        }
        if (content != null) {
            mask += 4;
        }
        EndPoint endPoint = this.connection.getEndPoint();
        switch (mask) {
            case 0: {
                endPoint.write(null, callback, new ByteBuffer[]{BufferUtil.EMPTY_BUFFER});
                break;
            }
            case 1: {
                endPoint.write(null, callback, new ByteBuffer[]{header});
                break;
            }
            case 2: {
                endPoint.write(null, callback, new ByteBuffer[]{chunk});
                break;
            }
            case 3: {
                endPoint.write(null, callback, new ByteBuffer[]{header, chunk});
                break;
            }
            case 4: {
                endPoint.write(null, callback, new ByteBuffer[]{content});
                break;
            }
            case 5: {
                endPoint.write(null, callback, new ByteBuffer[]{header, content});
                break;
            }
            case 6: {
                endPoint.write(null, callback, new ByteBuffer[]{chunk, content});
                break;
            }
            case 7: {
                endPoint.write(null, callback, new ByteBuffer[]{header, chunk, content});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected boolean commit(Request request) {
        block4: while (true) {
            State current = this.state.get();
            switch (current) {
                case SEND: {
                    if (!this.updateState(current, State.COMMIT)) continue block4;
                    LOG.debug("Committed {}", new Object[]{request});
                    this.requestNotifier.notifyHeaders(request);
                    return true;
                }
                case COMMIT: {
                    return this.updateState(current, State.COMMIT);
                }
            }
            break;
        }
        return false;
    }

    protected boolean success() {
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.requestComplete(null);
        if (!completion.isMarked()) {
            return false;
        }
        this.generator.reset();
        if (!this.updateState(State.COMMIT, State.IDLE)) {
            throw new IllegalStateException();
        }
        exchange.terminateRequest();
        Request request = exchange.getRequest();
        this.requestNotifier.notifySuccess(request);
        LOG.debug("Sent {}", new Object[]{request});
        Result result = completion.getReference();
        if (result != null) {
            this.connection.complete(exchange, !result.isFailed());
            HttpConversation conversation = exchange.getConversation();
            this.responseNotifier.notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    protected boolean fail(Throwable failure) {
        boolean notCommitted;
        State current;
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.requestComplete(failure);
        if (!completion.isMarked()) {
            return false;
        }
        this.generator.abort();
        while (!this.updateState(current = this.state.get(), State.FAILURE)) {
        }
        exchange.terminateRequest();
        Request request = exchange.getRequest();
        this.requestNotifier.notifyFailure(request, failure);
        LOG.debug("Failed {} {}", new Object[]{request, failure});
        Result result = completion.getReference();
        boolean bl = notCommitted = current == State.IDLE || current == State.SEND;
        if (result == null && notCommitted && request.getAbortCause() == null) {
            result = exchange.responseComplete(failure).getReference();
            exchange.terminateResponse();
            LOG.debug("Failed on behalf {}", new Object[]{exchange});
        }
        if (result != null) {
            this.connection.complete(exchange, false);
            HttpConversation conversation = exchange.getConversation();
            this.responseNotifier.notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    public boolean abort(HttpExchange exchange, Throwable cause) {
        State current = this.state.get();
        boolean abortable = current == State.IDLE || current == State.SEND || current == State.COMMIT && this.contentIterator.hasNext();
        return abortable && this.fail(cause);
    }

    private void releaseBuffers(ByteBufferPool bufferPool, ByteBuffer header, ByteBuffer chunk) {
        if (!BufferUtil.hasContent((ByteBuffer)header)) {
            bufferPool.release(header);
        }
        if (!BufferUtil.hasContent((ByteBuffer)chunk)) {
            bufferPool.release(chunk);
        }
    }

    private boolean updateState(State from, State to) {
        boolean updated = this.state.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.state.get()});
        }
        return updated;
    }

    private class ContentInfo {
        private final CountDownLatch latch = new CountDownLatch(1);
        public final boolean lastContent;
        public final ByteBuffer content;

        public ContentInfo(Iterator<ByteBuffer> contentIterator) {
            this.lastContent = !contentIterator.hasNext();
            this.content = this.lastContent ? BufferUtil.EMPTY_BUFFER : contentIterator.next();
        }

        public void ready() {
            this.latch.countDown();
        }

        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException x) {
                LOG.ignore((Throwable)x);
            }
        }
    }

    private static abstract class StatefulExecutorCallback
    implements Callback<Void>,
    Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.INCOMPLETE);
        private final Executor executor;

        private StatefulExecutorCallback(Executor executor) {
            this.executor = executor;
        }

        public final void completed(Void context) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.COMPLETE)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(this);
            }
        }

        @Override
        public final void run() {
            this.pendingCompleted();
        }

        protected abstract void pendingCompleted();

        public final void failed(Void context, final Throwable x) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.FAILED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        StatefulExecutorCallback.this.failed(x);
                    }
                });
            } else {
                this.failed(x);
            }
        }

        protected abstract void failed(Throwable var1);

        public boolean pending() {
            return this.state.compareAndSet(State.INCOMPLETE, State.PENDING);
        }

        public boolean completed() {
            return this.state.get() == State.COMPLETE;
        }

        public boolean failed() {
            return this.state.get() == State.FAILED;
        }

        private static enum State {
            INCOMPLETE,
            PENDING,
            COMPLETE,
            FAILED;

        }
    }

    private static enum State {
        IDLE,
        SEND,
        COMMIT,
        FAILURE;

    }
}

