/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);
    private final HttpClient client;

    public ResponseNotifier(HttpClient client) {
        this.client = client;
    }

    public void notifyBegin(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)listener, response);
        }
    }

    private void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            listener.onBegin(response);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)listener, response);
        }
    }

    private void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            listener.onHeaders(response);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyContent(List<Response.ResponseListener> listeners, Response response, ByteBuffer buffer) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.ContentListener)) continue;
            this.notifyContent((Response.ContentListener)listener, response, buffer);
        }
    }

    private void notifyContent(Response.ContentListener listener, Response response, ByteBuffer buffer) {
        try {
            listener.onContent(response, buffer);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)listener, response);
        }
    }

    private void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            listener.onSuccess(response);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response, failure);
        }
    }

    private void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            listener.onFailure(response, failure);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> listeners, Result result) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)listener, result);
        }
    }

    private void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            listener.onComplete(result);
        }
        catch (Exception x) {
            LOG.info("Exception while notifying listener " + listener, (Throwable)x);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response) {
        this.notifyBegin(listeners, response);
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(((ContentResponse)response).getContent()));
        }
        this.notifySuccess(listeners, response);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request, Response response) {
        HttpConversation conversation = this.client.getConversation(request.getConversationID(), false);
        this.forwardSuccess(listeners, response);
        conversation.complete();
        this.notifyComplete(listeners, new Result(request, response));
    }

    public void forwardFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        this.notifyBegin(listeners, response);
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(((ContentResponse)response).getContent()));
        }
        this.notifyFailure(listeners, response, failure);
    }

    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        HttpConversation conversation = this.client.getConversation(request.getConversationID(), false);
        this.forwardFailure(listeners, response, responseFailure);
        conversation.complete();
        this.notifyComplete(listeners, new Result(request, requestFailure, response, responseFailure));
    }
}

