/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.Schedulable;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimedResponseListener
implements Response.Listener,
Schedulable,
Runnable {
    private static final Logger LOG = Log.getLogger(TimedResponseListener.class);
    private final AtomicReference<Scheduler.Task> task = new AtomicReference();
    private final long timeout;
    private final TimeUnit unit;
    private final Request request;
    private final Response.CompleteListener delegate;

    public TimedResponseListener(long timeout, TimeUnit unit, Request request) {
        this(timeout, unit, request, new Response.Listener.Empty());
    }

    public TimedResponseListener(long timeout, TimeUnit unit, Request request, Response.CompleteListener delegate) {
        this.timeout = timeout;
        this.unit = unit;
        this.request = request;
        this.delegate = delegate;
    }

    @Override
    public void onBegin(Response response) {
        if (this.delegate instanceof Response.BeginListener) {
            ((Response.BeginListener)((Object)this.delegate)).onBegin(response);
        }
    }

    @Override
    public void onHeaders(Response response) {
        if (this.delegate instanceof Response.HeadersListener) {
            ((Response.HeadersListener)((Object)this.delegate)).onHeaders(response);
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        if (this.delegate instanceof Response.ContentListener) {
            ((Response.ContentListener)((Object)this.delegate)).onContent(response, content);
        }
    }

    @Override
    public void onSuccess(Response response) {
        if (this.delegate instanceof Response.SuccessListener) {
            ((Response.SuccessListener)((Object)this.delegate)).onSuccess(response);
        }
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        if (this.delegate instanceof Response.FailureListener) {
            ((Response.FailureListener)((Object)this.delegate)).onFailure(response, failure);
        }
    }

    @Override
    public void onComplete(Result result) {
        this.delegate.onComplete(result);
    }

    @Override
    public boolean schedule(Scheduler scheduler) {
        Scheduler.Task task = this.task.get();
        if (task != null) {
            return false;
        }
        task = scheduler.schedule((Runnable)this, this.timeout, this.unit);
        if (this.task.compareAndSet(null, task)) {
            LOG.debug("Scheduled timeout task {} in {} ms", new Object[]{task, this.unit.toMillis(this.timeout)});
            return true;
        }
        task.cancel();
        return false;
    }

    @Override
    public void run() {
        this.request.abort(new TimeoutException("Total timeout elapsed"));
    }

    @Override
    public boolean cancel() {
        Scheduler.Task task = this.task.get();
        if (task == null) {
            return false;
        }
        boolean result = task.cancel();
        LOG.debug("Cancelled timeout task {}", new Object[]{task});
        return result;
    }
}

