/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.util.Attributes;

public class HttpConversation
implements Attributes {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private final HttpClient client;
    private final long id;
    private volatile List<Response.ResponseListener> listeners;

    public HttpConversation(HttpClient client, long id) {
        this.client = client;
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public void setResponseListeners(List<Response.ResponseListener> listeners) {
        this.listeners = listeners;
    }

    public void complete() {
        this.client.removeConversation(this);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object attribute) {
        this.attributes.put(name, attribute);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public boolean abort(Throwable cause) {
        HttpExchange exchange = this.exchanges.peekLast();
        return exchange != null && exchange.abort(cause);
    }

    public String toString() {
        return String.format("%s[%d]", HttpConversation.class.getSimpleName(), this.id);
    }
}

