/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpSender {
    private static final Logger LOG = Log.getLogger(HttpSender.class);
    private static final String EXPECT_100_ATTRIBUTE = HttpSender.class.getName() + ".expect100";
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpConnection connection;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private Iterator<ByteBuffer> contentIterator;
    private ContentInfo expectedContent;

    public HttpSender(HttpConnection connection) {
        this.connection = connection;
        this.requestNotifier = new RequestNotifier(connection.getHttpClient());
        this.responseNotifier = new ResponseNotifier(connection.getHttpClient());
    }

    public void send(HttpExchange exchange) {
        if (!this.updateState(State.IDLE, State.BEGIN)) {
            throw new IllegalStateException();
        }
        HttpConversation conversation = exchange.getConversation();
        HttpExchange initialExchange = conversation.getExchanges().peekFirst();
        if (initialExchange == exchange) {
            conversation.setResponseListeners(exchange.getResponseListeners());
        } else {
            ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(exchange.getResponseListeners());
            listeners.addAll(initialExchange.getResponseListeners());
            conversation.setResponseListeners(listeners);
        }
        Request request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            exchange.abort(cause);
        } else {
            LOG.debug("Sending {}", new Object[]{request});
            this.requestNotifier.notifyBegin(request);
            ContentProvider content = request.getContent();
            this.contentIterator = content == null ? Collections.emptyIterator() : content.iterator();
            this.send();
        }
    }

    public void proceed(boolean proceed) {
        ContentInfo contentInfo = this.expectedContent;
        if (contentInfo != null) {
            if (proceed) {
                LOG.debug("Proceeding {}", new Object[]{this.connection.getExchange()});
                contentInfo.await();
                this.send();
            } else {
                HttpExchange exchange = this.connection.getExchange();
                if (exchange != null) {
                    this.fail(new HttpRequestException("Expectation failed", exchange.getRequest()));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void send() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void write(Callback callback, ByteBuffer header, ByteBuffer chunk, ByteBuffer content) {
        int mask = 0;
        if (header != null) {
            ++mask;
        }
        if (chunk != null) {
            mask += 2;
        }
        if (content != null) {
            mask += 4;
        }
        EndPoint endPoint = this.connection.getEndPoint();
        switch (mask) {
            case 0: {
                endPoint.write(callback, new ByteBuffer[]{BufferUtil.EMPTY_BUFFER});
                break;
            }
            case 1: {
                endPoint.write(callback, new ByteBuffer[]{header});
                break;
            }
            case 2: {
                endPoint.write(callback, new ByteBuffer[]{chunk});
                break;
            }
            case 3: {
                endPoint.write(callback, new ByteBuffer[]{header, chunk});
                break;
            }
            case 4: {
                endPoint.write(callback, new ByteBuffer[]{content});
                break;
            }
            case 5: {
                endPoint.write(callback, new ByteBuffer[]{header, content});
                break;
            }
            case 6: {
                endPoint.write(callback, new ByteBuffer[]{chunk, content});
                break;
            }
            case 7: {
                endPoint.write(callback, new ByteBuffer[]{header, chunk, content});
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected boolean commit(Request request) {
        block5: while (true) {
            State current = this.state.get();
            switch (current) {
                case SEND: {
                    if (!this.updateState(current, State.COMMIT)) continue block5;
                    LOG.debug("Committed {}", new Object[]{request});
                    this.requestNotifier.notifyCommit(request);
                    return true;
                }
                case COMMIT: {
                    if (this.updateState(current, State.COMMIT)) return true;
                    continue block5;
                }
                case FAILURE: {
                    return false;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected boolean success() {
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.requestComplete(null);
        if (!completion.isMarked()) {
            return false;
        }
        this.generator.reset();
        if (!this.updateState(State.COMMIT, State.IDLE)) {
            throw new IllegalStateException();
        }
        exchange.terminateRequest();
        Request request = exchange.getRequest();
        this.requestNotifier.notifySuccess(request);
        LOG.debug("Sent {}", new Object[]{request});
        Result result = completion.getReference();
        if (result != null) {
            this.connection.complete(exchange, !result.isFailed());
            HttpConversation conversation = exchange.getConversation();
            this.responseNotifier.notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    protected boolean fail(Throwable failure) {
        boolean notCommitted;
        State current;
        HttpExchange exchange = this.connection.getExchange();
        if (exchange == null) {
            return false;
        }
        AtomicMarkableReference<Result> completion = exchange.requestComplete(failure);
        if (!completion.isMarked()) {
            return false;
        }
        this.generator.abort();
        while (!this.updateState(current = this.state.get(), State.FAILURE)) {
        }
        exchange.terminateRequest();
        Request request = exchange.getRequest();
        this.requestNotifier.notifyFailure(request, failure);
        LOG.debug("Failed {} {}", new Object[]{request, failure});
        Result result = completion.getReference();
        boolean bl = notCommitted = current == State.IDLE || current == State.BEGIN || current == State.SEND;
        if (result == null && notCommitted && request.getAbortCause() == null) {
            result = exchange.responseComplete(failure).getReference();
            exchange.terminateResponse();
            LOG.debug("Failed on behalf {}", new Object[]{exchange});
        }
        if (result != null) {
            this.connection.complete(exchange, false);
            HttpConversation conversation = exchange.getConversation();
            this.responseNotifier.notifyComplete(conversation.getResponseListeners(), result);
        }
        return true;
    }

    public boolean abort(HttpExchange exchange, Throwable cause) {
        State current = this.state.get();
        boolean abortable = current == State.IDLE || current == State.BEGIN || current == State.SEND || current == State.COMMIT && this.contentIterator.hasNext();
        return abortable && this.fail(cause);
    }

    private void releaseBuffers(ByteBufferPool bufferPool, ByteBuffer header, ByteBuffer chunk) {
        if (!BufferUtil.hasContent((ByteBuffer)header)) {
            bufferPool.release(header);
        }
        if (!BufferUtil.hasContent((ByteBuffer)chunk)) {
            bufferPool.release(chunk);
        }
    }

    private boolean updateState(State from, State to) {
        boolean updated = this.state.compareAndSet(from, to);
        if (!updated) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.state.get()});
        }
        return updated;
    }

    private class ContentInfo {
        private final CountDownLatch latch = new CountDownLatch(1);
        public final boolean lastContent;
        public final ByteBuffer content;

        public ContentInfo(Iterator<ByteBuffer> contentIterator) {
            this.lastContent = !contentIterator.hasNext();
            this.content = this.lastContent ? BufferUtil.EMPTY_BUFFER : contentIterator.next();
        }

        public void ready() {
            this.latch.countDown();
        }

        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException x) {
                LOG.ignore((Throwable)x);
            }
        }
    }

    private static abstract class StatefulExecutorCallback
    implements Callback,
    Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.INCOMPLETE);
        private final Executor executor;

        private StatefulExecutorCallback(Executor executor) {
            this.executor = executor;
        }

        public final void succeeded() {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.SUCCEEDED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(this);
            }
        }

        @Override
        public final void run() {
            this.onSucceeded();
        }

        protected abstract void onSucceeded();

        public final void failed(final Throwable x) {
            State previous = this.state.get();
            while (!this.state.compareAndSet(previous, State.FAILED)) {
                previous = this.state.get();
            }
            if (previous == State.PENDING) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        StatefulExecutorCallback.this.onFailed(x);
                    }
                });
            } else {
                this.onFailed(x);
            }
        }

        protected abstract void onFailed(Throwable var1);

        public boolean process() {
            return this.state.compareAndSet(State.INCOMPLETE, State.PENDING);
        }

        public boolean isSucceeded() {
            return this.state.get() == State.SUCCEEDED;
        }

        public boolean isFailed() {
            return this.state.get() == State.FAILED;
        }

        private static enum State {
            INCOMPLETE,
            PENDING,
            SUCCEEDED,
            FAILED;

        }
    }

    private static enum State {
        IDLE,
        BEGIN,
        SEND,
        COMMIT,
        FAILURE;

    }
}

