/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpMethod;

public class RedirectProtocolHandler
extends Response.Listener.Empty
implements ProtocolHandler {
    private static final String ATTRIBUTE = RedirectProtocolHandler.class.getName() + ".redirects";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    public RedirectProtocolHandler(HttpClient client) {
        this.client = client;
        this.notifier = new ResponseNotifier(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        switch (response.getStatus()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return request.isFollowRedirects();
            }
        }
        return false;
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public void onComplete(Result result) {
        if (!result.isFailed()) {
            Request request = result.getRequest();
            Response response = result.getResponse();
            URI location = URI.create(response.getHeaders().get("location"));
            int status = response.getStatus();
            switch (status) {
                case 301: {
                    if (request.getMethod() == HttpMethod.GET || request.getMethod() == HttpMethod.HEAD) {
                        this.redirect(result, request.getMethod(), location);
                        break;
                    }
                    this.fail(result, new HttpResponseException("HTTP protocol violation: received 301 for non GET or HEAD request", response));
                    break;
                }
                case 302: 
                case 303: {
                    this.redirect(result, HttpMethod.GET, location);
                    break;
                }
                case 307: {
                    this.redirect(result, request.getMethod(), location);
                    break;
                }
                default: {
                    this.fail(result, new HttpResponseException("Unhandled HTTP status code " + status, response));
                    break;
                }
            }
        } else {
            this.fail(result, result.getFailure());
        }
    }

    private void redirect(Result result, HttpMethod method, URI location) {
        final Request request = result.getRequest();
        HttpConversation conversation = this.client.getConversation(request.getConversationID(), false);
        Integer redirects = (Integer)conversation.getAttribute(ATTRIBUTE);
        if (redirects == null) {
            redirects = 0;
        }
        if (redirects < this.client.getMaxRedirects()) {
            redirects = redirects + 1;
            conversation.setAttribute(ATTRIBUTE, redirects);
            Request redirect = this.client.copyRequest(request, location);
            redirect.method(method);
            redirect.onRequestBegin(new Request.BeginListener(){

                @Override
                public void onBegin(Request redirect) {
                    Throwable cause = request.getAbortCause();
                    if (cause != null) {
                        redirect.abort(cause);
                    }
                }
            });
            redirect.send(null);
        } else {
            this.fail(result, new HttpResponseException("Max redirects exceeded " + redirects, result.getResponse()));
        }
    }

    private void fail(Result result, Throwable failure) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        HttpConversation conversation = this.client.getConversation(request.getConversationID(), false);
        List<Response.ResponseListener> listeners = conversation.getExchanges().peekFirst().getResponseListeners();
        this.notifier.notifyFailure(listeners, response, failure);
        this.notifier.notifyComplete(listeners, new Result(request, response, failure));
    }
}

