/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.client.AsyncContentProvider;

public class DeferredContentProvider
implements AsyncContentProvider,
AutoCloseable {
    private final Queue<ByteBuffer> queue = new ConcurrentLinkedQueue<ByteBuffer>();
    private volatile AsyncContentProvider.Listener listener;
    private volatile boolean closed;

    public DeferredContentProvider(ByteBuffer ... buffers) {
        for (ByteBuffer buffer : buffers) {
            this.queue.offer(buffer);
        }
    }

    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        this.listener = listener;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    public boolean offer(ByteBuffer buffer) {
        boolean result = this.queue.offer(buffer);
        this.notifyListener(false);
        return result;
    }

    @Override
    public void close() {
        this.closed = true;
        this.notifyListener(true);
    }

    private void notifyListener(boolean last) {
        AsyncContentProvider.Listener listener = this.listener;
        if (listener != null) {
            listener.onContent(last);
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){

            @Override
            public boolean hasNext() {
                return !DeferredContentProvider.this.queue.isEmpty() || !DeferredContentProvider.this.closed;
            }

            @Override
            public ByteBuffer next() {
                return (ByteBuffer)DeferredContentProvider.this.queue.poll();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

