/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpExchange {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final AtomicInteger complete = new AtomicInteger();
    private final CountDownLatch terminate = new CountDownLatch(2);
    private final HttpConversation conversation;
    private final HttpDestination destination;
    private final Request request;
    private final List<Response.ResponseListener> listeners;
    private final HttpResponse response;
    private volatile HttpConnection connection;
    private volatile Throwable requestFailure;
    private volatile Throwable responseFailure;

    public HttpExchange(HttpConversation conversation, HttpDestination destination, Request request, List<Response.ResponseListener> listeners) {
        this.conversation = conversation;
        this.destination = destination;
        this.request = request;
        this.listeners = listeners;
        this.response = new HttpResponse(request, listeners);
        conversation.getExchanges().offer(this);
        conversation.updateResponseListeners(null);
    }

    public HttpConversation getConversation() {
        return this.conversation;
    }

    public Request getRequest() {
        return this.request;
    }

    public Throwable getRequestFailure() {
        return this.requestFailure;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Throwable getResponseFailure() {
        return this.responseFailure;
    }

    public void setConnection(HttpConnection connection) {
        this.connection = connection;
    }

    public AtomicMarkableReference<Result> requestComplete(Throwable failure) {
        int requestSuccess = 3;
        int requestFailure = 1;
        return this.complete(failure == null ? requestSuccess : requestFailure, failure);
    }

    public AtomicMarkableReference<Result> responseComplete(Throwable failure) {
        if (failure == null) {
            int responseSuccess = 12;
            return this.complete(responseSuccess, failure);
        }
        this.proceed(false);
        int responseFailure = 4;
        return this.complete(responseFailure, failure);
    }

    private AtomicMarkableReference<Result> complete(int code, Throwable failure) {
        int completed;
        int current;
        boolean modified;
        Result result;
        block5: {
            int candidate;
            result = null;
            modified = false;
            do {
                boolean updateable;
                boolean bl = updateable = ((current = this.complete.get()) & code) == 0;
                if (!updateable) break block5;
            } while (!this.complete.compareAndSet(current, candidate = current | code));
            current = candidate;
            modified = true;
            if ((code & 1) == 1) {
                this.requestFailure = failure;
            } else {
                this.responseFailure = failure;
            }
            LOG.debug("{} updated", new Object[]{this});
        }
        if ((current & (completed = 5)) == completed) {
            if (modified) {
                LOG.debug("{} complete", new Object[]{this});
                this.conversation.complete();
            }
            result = new Result(this.getRequest(), this.getRequestFailure(), this.getResponse(), this.getResponseFailure());
        }
        return new AtomicMarkableReference<Object>(result, modified);
    }

    public boolean abort(Throwable cause) {
        if (this.destination.remove(this)) {
            this.destination.abort(this, cause);
            LOG.debug("Aborted while queued {}: {}", new Object[]{this, cause});
            return true;
        }
        HttpConnection connection = this.connection;
        if (connection == null) {
            return false;
        }
        boolean aborted = connection.abort(cause);
        LOG.debug("Aborted while active ({}) {}: {}", new Object[]{aborted, this, cause});
        return aborted;
    }

    public void resetResponse(boolean success) {
        int responseSuccess = 12;
        int responseFailure = 4;
        int code = success ? responseSuccess : responseFailure;
        this.complete.addAndGet(-code);
    }

    public void proceed(boolean proceed) {
        HttpConnection connection = this.connection;
        if (connection != null) {
            connection.proceed(proceed);
        }
    }

    public void terminateRequest() {
        this.terminate.countDown();
    }

    public void terminateResponse() {
        this.terminate.countDown();
    }

    public void awaitTermination() {
        try {
            this.terminate.await();
        }
        catch (InterruptedException x) {
            LOG.ignore((Throwable)x);
        }
    }

    public String toString() {
        String padding = "0000";
        String status = Integer.toBinaryString(this.complete.get());
        return String.format("%s@%x status=%s%s", HttpExchange.class.getSimpleName(), this.hashCode(), padding.substring(status.length()), status);
    }
}

